/********************************  EEPROM.H  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Internal EEPROM address definitions
 *
 * Author:   Peter Shorty
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 21393 $
 * Last Changed:     $Date: 2011-09-27 16:28:02 +0200 (Tue, 27 Sep 2011) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <myStromMeter.h>

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* EEPROM address definitions */

/* EEPROM myStrom battery meter node layout */
#define EEOFFSET_METER_MODE               0x00
#define EEOFFSET_METER_CVALUE_1           EEOFFSET_METER_MODE + 1
#define EEOFFSET_METER_CVALUE_2           EEOFFSET_METER_CVALUE_1 + 1

#define EEOFFSET_POWERDOWNTIMEOUT         EEOFFSET_METER_CVALUE_2 + 1
#define EEOFFSET_KEEPALIVETIMEOUT         EEOFFSET_POWERDOWNTIMEOUT + 1
#define EEOFFSET_KEEPALIVEACTIVATETIMEOUT EEOFFSET_KEEPALIVETIMEOUT + 1

#define EEOFFSET_MASTER_NODEID            EEOFFSET_KEEPALIVEACTIVATETIMEOUT + 1
#define EEOFFSET_SLEEP_PERIOD_1           EEOFFSET_MASTER_NODEID + 1
#define EEOFFSET_SLEEP_PERIOD_2           EEOFFSET_SLEEP_PERIOD_1 + 1
#define EEOFFSET_SLEEP_PERIOD_3           EEOFFSET_SLEEP_PERIOD_2 + 1

#ifdef ZW_SELF_HEAL
#define EEOFFSET_LOST_COUNTER             EEOFFSET_SLEEP_PERIOD_3 + 1
#define EEOFFSET_COMMON_END               EEOFFSET_LOST_COUNTER
#else
#define EEOFFSET_COMMON_END               EEOFFSET_SLEEP_PERIOD_3
#endif /*ZW_SELF_HEAL*/

#define EEOFFSET_LERN_MODE		  EEOFFSET_COMMON_END + 1	
#define EEOFFSET_MAGIC                    EEOFFSET_LERN_MODE + 1  /* MAGIC */

#define EEOFFSET_ASSOCIATION_START        EEOFFSET_MAGIC + 1
#define EEOFFSET_ASSOCIATION_MAGIC        EEOFFSET_ASSOCIATION_START + ASSOCIATION_SIZE

#define EEOFFSET_TRANSPORT_SETTINGS_START EEOFFSET_ASSOCIATION_MAGIC + 1
#define EEOFFSET_TRANSPORT_SETTINGS_SIZE  TRANSPORT_EEPROM_SETTINGS_SIZE

#endif /* _EEPROM_H_ */
