@echo off
rem ***************************  make_release.bat  ***************************
rem            #######
rem            ##  ##
rem            #  ##    ####   #####    #####  ##  ##   #####
rem              ##    ##  ##  ##  ##  ##      ##  ##  ##
rem             ##  #  ######  ##  ##   ####   ##  ##   ####
rem            ##  ##  ##      ##  ##      ##   #####      ##
rem           #######   ####   ##  ##  #####       ##  #####
rem                                            #####
rem           Z-Wave, the wireless language.
rem
rem               Copyright (c) 2009
rem               Zensys A/S
rem               Denmark
rem
rem               All Rights Reserved
rem
rem     This source file is subject to the terms and conditions of the
rem     Zensys Software License Agreement which restricts the manner
rem     in which it may be used.
rem
rem ---------------------------------------------------------------------------
rem
rem  Description: DOS Batchfile updates and cleans up source code and
rem               creates a version stripped from unused defines based
rem               on a SVN revision
rem
rem  Author:   Erik Friis Harck
rem
rem  Last Changed By:  $Author: efh $
rem  Revision:         $Revision: 18302 $
rem  Last Changed:     $Date: 2010-07-20 14:51:38 +0200 (ti, 20 jul 2010) $
rem
rem ****************************************************************************

REM Application version placement definition
REM SET APPVERSOURCEFILE=   <nothing> to skip version check
SET APPVERSOURCEFILE=config_app.h
SET APPVERSIONDEFINE=APP_VERSION
SET APPREVISIONDEFINE=APP_REVISION

REM Assume next macros is undefined and remove source code in #ifdef with this macros (leave code in #ifndef/#else)
SET UDEF=-U__ICCAVR__ -UDEB -UDEBUG_STRESS -UDEBUGIE -UZW020x_LED_ALPHA -UZW_CONTROLLER_STATIC -USTATIC_SUC -UZW_VERSION_BETA

REM Assume next macros is defined and leave source code in #ifdef with this macros (remove code in #ifndef/#else)
SET DEF=-DNEW_NODEINFO -DZW_SLAVE -DAPPL_PROD_TEST
REM OLD SET DEF=-DNEW_NODEINFO -D__C51__

REM Do we need make binaries?
SET MAKE_BINARIES=TRUE

rem ****************************************************************************
set TOOLDIR=%SW_PGM%\Tools
:done_toolsdir
set TXTTOOLSDIR=%TOOLDIR%\texttools
SET SVNDIR=%TOOLDIR%\svntools
REM SET SVNDIR="C:\Program Files\CollabNet\Subversion Client"
SET SED=%TOOLDIR%\texttools\sed-4-1-5\sed

set ENTRYDIR=%CD%

REM - If no version parameters given, try to find the parameters automatically.
if not "%1"=="auto" goto CheckStandardParameters

SET release_name=%~2

goto SetEnvironment

:CheckStandardParameters
REM Any oldsvnrevision
if "%6"=="" goto usage
REM Any svnrevision
if "%5"=="" goto usage
REM Any Util version
if "%4"=="" goto usage
REM Any Lib version
if "%3"=="" goto usage
REM Any release version
if "%2"=="" goto usage
REM Target CPU
if not "%1"=="ZW0x0x" goto usage

SET release_name=%~7
SET oldsvnrevision=%6
SET svnrevision=%5
SET util_version=%4
SET library_version=%3
SET release_version=%2

:SetEnvironment

if "%release_name%"=="" SET /P release_name="Name of release [DevKit x.yy TRzz]? "

REM Set users environment for mantra
REM Check which version of SVN/TortoiseSVN was used for checking out this working directory...
REM  The first line of .svn\entries indicates this
REM  8  -> subversion version 1.4.x
REM  10 -> subversion version 1.6.x
findstr /N [0-9] .svn\entries | findstr /C:"^1:8" /R >NUL
if NOT ERRORLEVEL 1 set SVNDIR=%SVNDIR%\v1.4.5
findstr /N [0-9] .svn\entries | findstr /C:"^1:10" /R >NUL
if NOT ERRORLEVEL 1 set SVNDIR=%SVNDIR%\v1.6.12
echo Using %SVNDIR% for Subversion command line client.
REM get %TortoiseSVN% variable
reg query HKEY_CURRENT_USER\Software\TortoiseSVN /v CurrentVersion | findstr CurrentVersion | %SED% -e "s~.*REG_SZ\t\(.*,.*\),.*,.*~set TortoiseSVN=\1~" -e "s~, ~\.~g" > setenvironment.bat
REM get %CLISVN% variable
%SVNDIR%\svn --version --quiet | %SED% -e "s~\([0-9]*\.[0-9]*\).*~set CLISVN=\1~" >> setenvironment.bat
echo %ENTRYDIR%| %SED% -e "s/.*\\Product\\\(.*\)/\1/" -e "s/\(.*\\branches\\.*\)\\.*/\1/" -e "s/.*\\\(.*\)/\1/" -e "s/\(.*\)/set APPDIR\=\1/" >> setenvironment.bat
echo %ENTRYDIR%| %SED% -e "s/.*\\mantra\(.*\)/\1/" -e "s/.*\\branches\\.*\\\(.*branch\)\(\\.*\)*/\1/" -e "s/\\\(.*\)\\.*/\1/" -e "s/\\Product//" -e "s/\(.*\)/set APPBRANCH\=\1/" >> setenvironment.bat
echo set PARENTWORKDIR=%ENTRYDIR% | %SED% s/\\mantra.*// >> setenvironment.bat
echo %ENTRYDIR%| %SED% -e "s~.*\\\(mantra.*\)~set SVNBRANCHURL=https://zensys14/svn/\1~" -e "s~\\~/~g" >> setenvironment.bat
echo %ENTRYDIR%| %SED% -e "s~.*\\\(mantra\w*\).*~set SVNRELEASEURL=https://zensys14/svn/\1/releases~" -e "s~\\~/~g" >> setenvironment.bat
call setenvironment.bat
del setenvironment.bat

if "%APPBRANCH%"=="trunk" (
  set LIBBRANCHDIR=/trunk/Z-Wave/
  set UTILBRANCHDIR=/trunk/Product/util_func/
  set APPBRANCHDIR=/trunk/Product/%APPDIR%/
) else (
  set LIBBRANCHDIR=/branches/Z-Wave/%APPBRANCH%/
  set UTILBRANCHDIR=/branches/Product/%APPBRANCH%/util_func/
  set APPBRANCHDIR=/branches/Product/%APPBRANCH%/%APPDIR%/
)

REM Make a check of your TortoiseSVN- and your command line SVN clent installations if they are in sync.
IF NOT %TortoiseSVN%==%CLISVN% goto svnoutofsync

REM - Set variables for environment
SET SVNRELEASEDIR=%PARENTWORKDIR%\mantra
SET SVNRELEASEDIRSRCPRODUCT=%PARENTWORKDIR%\mantra\releases\Product\src\%APPDIR%
SET SVNRELEASEDIRLOGPRODUCT=%PARENTWORKDIR%\mantra\releases\Logs\%APPDIR%
SET SVNRELEASEURLSRCPRODUCT=%SVNRELEASEURL%/Product/src/%APPDIR%
SET SVNRELEASEURLLOGPRODUCT=%SVNRELEASEURL%/Logs/%APPDIR%

REM - If no version parameters given, try to find the parameters automatically.
if not "%1"=="auto" goto DropFindParameters

REM - SVN-Update the working copies of Logs-directories we are going to refer to
%SVNDIR%\svn update -q %PARENTWORKDIR%\mantra\releases\Logs\Z-Wave
if ERRORLEVEL 1 goto errorSVN
%SVNDIR%\svn update -q %PARENTWORKDIR%\mantra\releases\Logs\util_func
if ERRORLEVEL 1 goto errorSVN
%SVNDIR%\svn update -q %SVNRELEASEDIRLOGPRODUCT%
if ERRORLEVEL 1 goto errorSVN

REM - Find the latest released version number of "Z-Wave" library on this branch
echo @set PARENTWORKDIRDOUBLE=%%PARENTWORKDIR:\=\\%%> auto-release-latest-lib.bat
echo @for /D %%%%i in (%%PARENTWORKDIR%%\mantra\releases\Logs\Z-Wave\*) do @if exist %%%%i\svnlog.txt @findstr /R /M /C:"^   . %LIBBRANCHDIR%" %%%%i\svnlog.txt^| %%SED%% -e "s/%%PARENTWORKDIRDOUBLE%%\\mantra\\releases\\Logs\\Z-Wave\\//">> auto-release-latest-lib.bat
echo @set PARENTWORKDIRDOUBLE=>> auto-release-latest-lib.bat
for /F "usebackq delims=\" %%J in (`auto-release-latest-lib.bat`) do @set library_version=%%J
set library_version=%library_version:ver=%
if exist auto-release-latest-lib.bat del auto-release-latest-lib.bat

REM - Find the latest released version number of "util_func" on this branch
echo @set PARENTWORKDIRDOUBLE=%%PARENTWORKDIR:\=\\%%> auto-release-latest-util_func.bat
echo @for /D %%%%i in (%%PARENTWORKDIR%%\mantra\releases\Logs\util_func\*) do @if exist %%%%i\svnlog.txt @findstr /R /M /C:"^   . %UTILBRANCHDIR%" %%%%i\svnlog.txt^| %%SED%% -e "s/%%PARENTWORKDIRDOUBLE%%\\mantra\\releases\\Logs\\util_func\\//">> auto-release-latest-util_func.bat
echo @set PARENTWORKDIRDOUBLE=>> auto-release-latest-util_func.bat
for /F "usebackq delims=\" %%J in (`auto-release-latest-util_func.bat`) do @set util_version=%%J
set util_version=%util_version:ver=%
if exist auto-release-latest-util_func.bat del auto-release-latest-util_func.bat

REM - Find the latest released version number of this application on this branch
echo @set SVNRELEASEDIRLOGPRODUCTDOUBLE=%%SVNRELEASEDIRLOGPRODUCT:\=\\%%> auto-release-latest-app.bat
echo @for /D %%%%I in (%%SVNRELEASEDIRLOGPRODUCT%%\*) do @if exist %%%%I\svnlog.txt @findstr /R /M /C:"^   . %APPBRANCHDIR%" %%%%I\svnlog.txt^| %%SED%% -e "s/%%SVNRELEASEDIRLOGPRODUCTDOUBLE%%\\//">> auto-release-latest-app.bat
echo @set SVNRELEASEDIRLOGPRODUCTDOUBLE=>> auto-release-latest-app.bat
for /F "usebackq delims=\" %%J in (`auto-release-latest-app.bat`) do @set OLDVERSIONDIR=%%J
if not "%OLDVERSIONDIR%" == "" @(set OLDVERSION=%OLDVERSIONDIR:ver=%)
if exist auto-release-latest-app.bat del auto-release-latest-app.bat

REM - Find the latest released version number of this application
for /D %%I in (%SVNRELEASEDIRLOGPRODUCT%\*) do @set LATESTVERSION=%%~nI
set LATESTVERSION=%LATESTVERSION:ver=%

REM - Compute the new version to be released of this application
set LATESTVERSION=%LATESTVERSION:_=%
set /A release_version=%LATESTVERSION%+1
set NEWVERSIONMAJOR=%release_version:~0,-2%
set NEWVERSIONMINOR=%release_version:~-2%
set release_version=%NEWVERSIONMAJOR%_%NEWVERSIONMINOR%

REM - Find the latest released SVN-revision number of this application on this branch
set oldsvnrevision=1
if not "%OLDVERSIONDIR%" == "" @for /F "usebackq eol=-" %%L in (`"%SVNDIR%\svn" log -q --limit 1 %SVNRELEASEDIRLOGPRODUCT%\%OLDVERSIONDIR%`) do @set oldsvnrevision=%%L
set oldsvnrevision=%oldsvnrevision:r=%

REM - Autoedit new version number into %APPVERSOURCEFILE%
if "%APPVERSOURCEFILE%"=="" goto SkipVersionUpdate
%SED% -T -r -e "s/(#define APP_VERSION).*/\1 %NEWVERSIONMAJOR%/" -e "s/(#define APP_REVISION).*/\1 %NEWVERSIONMINOR%/" -e "s/(#define APP_REVISION) 0*([0-9].*)/\1 \2/" %APPVERSOURCEFILE% > %APPVERSOURCEFILE%.tmp
REM - Check if we really changed the file
fc %APPVERSOURCEFILE%.tmp %APPVERSOURCEFILE% > nul
if ERRORLEVEL 1 (
  if exist %APPVERSOURCEFILE%.bak del %APPVERSOURCEFILE%.bak
  rename %APPVERSOURCEFILE% %APPVERSOURCEFILE%.bak
  rename %APPVERSOURCEFILE%.tmp %APPVERSOURCEFILE%
  @echo Commit the application version config file "%APPVERSOURCEFILE%"
  %SVNDIR%\svn.exe commit -m "Automated update of %APPDIR%\%APPVERSOURCEFILE% to v%release_version%" %APPVERSOURCEFILE%
  if ERRORLEVEL 1 goto errorSVN
) else (
  if exist %APPVERSOURCEFILE%.tmp del %APPVERSOURCEFILE%.tmp
)
:SkipVersionUpdate

REM - Find the new SVN-revision number of this application on this branch
for /F "usebackq eol=-" %%L in (`"%SVNDIR%\svn" log -q --limit 1 %SVNBRANCHURL%`) do @set svnrevision=%%L
set svnrevision=%svnrevision:r=%

@echo Parameters found automatically:
@echo library_version: %library_version%
@echo util_version:    %util_version%
REM @echo OLDVERSIONDIR:   %OLDVERSIONDIR%
@echo OLDVERSION:      %OLDVERSION%
REM @echo LATESTVERSION:   %LATESTVERSION%
@echo release_version: %release_version%
@echo oldsvnrevision:  %oldsvnrevision%
@echo svnrevision:     %svnrevision%

:DropFindParameters

REM - Set variables for specific release version
SET SVNRELEASEDIRSRC=%SVNRELEASEDIRSRCPRODUCT%\ver%release_version%
SET SVNRELEASEURLSRC=%SVNRELEASEURLSRCPRODUCT%/ver%release_version%
SET SVNRELEASEDIRBIN=%PARENTWORKDIR%\mantra\releases\Z-Wave\bin\ver%library_version%
SET SVNRELEASEURLBIN=%SVNRELEASEURL%/Z-Wave/bin/ver%library_version%
SET SVNRELEASEDIRLOG=%SVNRELEASEDIRLOGPRODUCT%\ver%release_version%
SET SVNLIBRELEASEDIRBIN=%PARENTWORKDIR%\mantra\releases\Z-Wave\bin\ver%library_version%
SET ZWUTILDIR=%PARENTWORKDIR%\mantra\releases\Product\src\util_func\ver%util_version%
SET ZWUTILURL=%SVNRELEASEURL%/Product/src/util_func/ver%util_version%

@echo %APPDIR%^> %0 ZW0x0x %release_version% %library_version% %util_version% %svnrevision% %oldsvnrevision% "%release_name%"
@echo -------------------------------------------------------------------------------

SET CPU=ZW0x0x

if "%APPVERSOURCEFILE%"=="" goto SkipVersionCheck
@copy %TOOLDIR%\buildversion\buildversion.exe
buildversion -f %APPVERSOURCEFILE% -d %APPVERSIONDEFINE% %APPREVISIONDEFINE% -v %release_version%
if ERRORLEVEL = 1 goto errorVersion
del buildversion.exe
:SkipVersionCheck

if "%library_version%"=="x" goto SkipASICLibCopy
if "%library_version%"=="trunk" goto SkipASICLibCopy
@echo Exporting a copy of the referenced release "ver%library_version%" of Z-Wave library...
REM In fact overwriting any tampering with the library, if you have a local copy.
%SVNDIR%\svn.exe export --force %SVNRELEASEURLBIN% %SVNRELEASEDIRBIN%
if ERRORLEVEL 1 goto errorSVN

:SkipASICLibCopy

if "%util_version%"=="x" goto SkipUtilCopy
@echo Exporting a copy of the referenced release "ver%util_version%" of "util_func"...
REM In fact overwriting any tampering with "util_func", if you have a local copy.
%SVNDIR%\svn.exe export --force %ZWUTILURL% %ZWUTILDIR%
if ERRORLEVEL 1 goto errorSVN

:SkipUtilCopy

@echo Generating release source directory for %APPDIR%...
REM First make a check if this is the first release of %APPDIR%
%SVNDIR%\svn.exe log --quiet --limit 1 %SVNRELEASEURLSRCPRODUCT%
if NOT ERRORLEVEL 1 goto SkipSvnReleaseDirSrcProductCreation
@echo The error above is expected: svn: REPORT request failed on...
@echo Making directory "%APPDIR%" in repository
%SVNDIR%\svn.exe mkdir -m "Preparing for first release of %APPDIR%" %SVNRELEASEURLSRCPRODUCT%
if ERRORLEVEL 1 goto errorSVN

:SkipSvnReleaseDirSrcProductCreation
@echo Make sure we have a working directory for "%APPDIR%" to hold the release
if not exist %SVNRELEASEURLSRCPRODUCT%\NUL %SVNDIR%\svn.exe checkout --non-recursive %SVNRELEASEURLSRCPRODUCT% %SVNRELEASEDIRSRCPRODUCT%
if ERRORLEVEL 1 goto errorSVN

@echo Check if "ver%release_version%" of the "%APPDIR%" is already released.
@echo (this check should normally result in an error like this: svn: REPORT request failed on...)
%SVNDIR%\svn.exe log --quiet --limit 1 %SVNRELEASEURLSRC%
if NOT ERRORLEVEL 1 goto ErrorVersionExists

if not exist %SVNRELEASEDIRSRC% mkdir %SVNRELEASEDIRSRC%
@echo Add the directory "%SVNRELEASEDIRSRC%"
%SVNDIR%\svn.exe add %SVNRELEASEDIRSRC%
if ERRORLEVEL 1 goto errorSVN
@for %%i in (*.c) do %SVNDIR%\svn.exe copy -r %svnrevision% %ENTRYDIR%\%%i %SVNRELEASEDIRSRC%\%%i
@for %%i in (*.h) do %SVNDIR%\svn.exe copy -r %svnrevision% %ENTRYDIR%\%%i %SVNRELEASEDIRSRC%\%%i
@for %%i in (Makefile.*.) do %SVNDIR%\svn.exe copy -r %svnrevision% %ENTRYDIR%\%%i %SVNRELEASEDIRSRC%\%%i
@for %%i in (MK.bat) do %SVNDIR%\svn.exe copy -r %svnrevision% %ENTRYDIR%\%%i %SVNRELEASEDIRSRC%\%%i
@for %%i in (*.Uv2) do %SVNDIR%\svn.exe copy -r %svnrevision% %ENTRYDIR%\%%i %SVNRELEASEDIRSRC%\%%i
@for %%i in (*.mpw) do %SVNDIR%\svn.exe copy -r %svnrevision% %ENTRYDIR%\%%i %SVNRELEASEDIRSRC%\%%i

@echo Commit the directory "%SVNRELEASEDIRSRC%"
%SVNDIR%\svn.exe commit -m "Temp release of %APPDIR% ver%release_version% source"  %SVNRELEASEDIRSRC%
if ERRORLEVEL 1 goto errorSVN

cd %SVNRELEASEDIRSRC%

set TARGET=ZW0x0x

:do_make
@call mk clean

@echo Cleaning code...
if not exist %SVNRELEASEDIRSRC%\tmp mkdir %SVNRELEASEDIRSRC%\tmp
@for %%i in (*.c) do @%SW_PGM%\Tools\unifdef\unifdef %DEF% %UDEF% %%i > tmp\%%i
@for %%i in (*.h) do @%SW_PGM%\Tools\unifdef\unifdef %DEF% %UDEF% %%i > tmp\%%i
@for %%i in (*.c) do @move /Y tmp\%%i %%i
@for %%i in (*.h) do @move /Y tmp\%%i %%i
if exist %SVNRELEASEDIRSRC%\tmp rmdir %SVNRELEASEDIRSRC%\tmp

if NOT "%MAKE_BINARIES%"=="TRUE" goto SkipMakeBinaries
@echo Make test frequency enabled targets...
@call mk %TARGET%_tf

@echo Make targets
@call mk %TARGET%

@echo Cleaning binaries...
if not exist build\NUL goto SkipCleaningBinaries
@del /F /S /Q build\*.lst >nul
@del /F /S /Q build\*.obj >nul
@del /F /S /Q build\*.d >nul
@del /F /S /Q build\*.AOF >nul
@del /F /S /Q build\*.map >nul
@del /F /S /Q build\*.reg >nul
@del /F /S /Q build\*.sbr >nul
@for /D %%i in (build\*.*) do @rd /S /Q "%%i\list"
@for /D %%i in (build\*.*) do @rd /S /Q "%%i\Rels"
:SkipCleaningBinaries

@echo Add the binaries to the repository
%SVNDIR%\svn.exe add %SVNRELEASEDIRSRC%\build
if ERRORLEVEL 1 goto errorSVN

:SkipMakeBinaries

@echo Commit release of source and binaries... (please wait)
%SVNDIR%\svn.exe commit -m "Release of %APPDIR% ver%release_version%"  %SVNRELEASEDIRSRC%
if ERRORLEVEL 1 goto errorSVN

:: Generate text files
@echo Generate SVN log file...
REM First make a check if this is the first release of %APPDIR%
%SVNDIR%\svn.exe log --quiet --limit 1 %SVNRELEASEURLLOGPRODUCT%
if NOT ERRORLEVEL 1 goto SkipSvnReleaseDirLogProductCreation

@echo Making Logs directory "%APPDIR%" in repository
%SVNDIR%\svn.exe mkdir -m "Preparing for first release of %APPDIR% logs" %SVNRELEASEURLLOGPRODUCT%
if ERRORLEVEL 1 goto errorSVN

@echo Make sure we have a Logs working directory for "%APPDIR%" to hold the release
%SVNDIR%\svn.exe checkout --non-recursive %SVNRELEASEURLLOGPRODUCT% %SVNRELEASEDIRLOGPRODUCT%
if ERRORLEVEL 1 goto errorSVN

:SkipSvnReleaseDirLogProductCreation

if not exist %SVNRELEASEDIRLOG%\NUL mkdir %SVNRELEASEDIRLOG% >NUL
if "%oldsvnrevision%"=="" goto generateText
@echo Generate SVN log file...
@call %SVNDIR%\svn.exe log -v -r %svnrevision%:%oldsvnrevision% %SVNBRANCHURL% > svntaglog.txt
if not exist svntaglog.txt goto generateText
@echo Changes in the %APPDIR% sample application files>%SVNRELEASEDIRLOG%\svnlog.txt
@type svntaglog.txt >>%SVNRELEASEDIRLOG%\svnlog.txt
@del svntaglog.txt

:generateText
@echo Making dirlist.txt...
@mkdir ..\%APPDIR%_temp
@xcopy /S /Q %SVNRELEASEDIRSRC% ..\%APPDIR%_temp
@dir /s ..\%APPDIR%_temp | %SED% -e "s/\\%APPDIR%_temp/\\ver%release_version%/g" >dir.txt
@rmdir /S /Q ..\%APPDIR%_temp
REM @dir /s %SVNRELEASEDIRSRC% >dir.txt
@copy %TOOLDIR%\texttools\dirlist.exe
@dirlist dir.txt %SVNRELEASEDIRLOG%\dirlist.txt
@del dir.txt
@del dirlist.exe

@echo Making note.txt...
@echo - Released for %release_name%, built on branch "%APPBRANCH%" >%SVNRELEASEDIRLOG%\note.txt
@echo %APPDIR% for ZW0x0x release ver%release_version% built on ZW0x0x API ver%library_version% and UTIL_FUNC ver%util_version% >>%SVNRELEASEDIRLOG%\note.txt
@echo %APPDIR% made by calling "%0 ZW0x0x %release_version% %library_version% %util_version% %svnrevision% %oldsvnrevision%" >>%SVNRELEASEDIRLOG%\note.txt
@echo %APPDIR% target built with "mk %TARGET%" >>%SVNRELEASEDIRLOG%\note.txt
@echo The following #define were enabled using unifdef: %DEF% >>%SVNRELEASEDIRLOG%\note.txt
@echo The following #define were removed using unifdef: %UDEF% >>%SVNRELEASEDIRLOG%\note.txt
@echo source used from SVN with revision "%svnrevision%" >>%SVNRELEASEDIRLOG%\note.txt

:get_out

@echo Adding logs to repository...
%SVNDIR%\svn.exe add %SVNRELEASEDIRLOG%
if ERRORLEVEL 1 goto errorSVN

@echo Committing logs to repository...
%SVNDIR%\svn.exe commit -m "Release of %APPDIR% ver%release_version% logs"  %SVNRELEASEDIRLOG%
if ERRORLEVEL 1 goto errorSVN

@echo all done!
goto exit

:errorSVN
@echo There is probably something wrong with your repository or working directory.
@echo Please correct it, and try again.
goto exit

:svnoutofsync
@echo Your Subversion client installations are out of sync
@echo TortoiseSVN=%TortoiseSVN%
@echo CLISVN=%CLISVN%
goto exit

:ErrorVersionExists
@echo ERROR: %APPDIR% %release_version% is already released.
goto exit

:errorVersion
del buildversion.exe
@echo ERROR %APPVERSOURCEFILE% not version %release_version%
goto exit

:usage
@echo -------------------------------------------------------------------------------
@echo USAGE:
@echo  %0 ZW0x0x release_version library_version util_version svnrevision oldsvnrevision "release_name"
@echo or:
@echo  %0 auto "release_name"
@echo -------------------------------------------------------------------------------
@echo Please make sure that everything is up to date and checkedin!!!!
@echo The "svnrevision" is the revision, that is going to be released.
@echo "svnrevision" and "oldsvnrevision" are used for generating a svnlog.txt listing
@echo - the changes made in the application source since "oldsvnrevision"
@echo - in releasedir
@echo "release_name" is used for generating a note.txt (include the quotes)
@echo If using "auto", the parameters will be found automatically from the Subversion repository.
@echo -------------------------------------------------------------------------------
goto exit

:set_toolsdir
@echo -------------------------------------------------------------------------------
@echo ERROR: RELTOOLSDIR should be set to checkout of mantra, zensystools
@echo -------------------------------------------------------------------------------

:exit
cd %ENTRYDIR%
SET ZWLIB=
SET TXTTOOLSDIR=
SET SED=
SET CPU=
SET TARGET=
SET MAKE_BINARIES=
SET ENTRYDIR=
SET PARENTWORKDIR=
SET SVNBRANCHURL=
SET SVNRELEASEURL=
SET SVNRELEASEDIR=
SET SVNRELEASEDIRSRCPRODUCT=
SET SVNRELEASEURLSRCPRODUCT=
SET SVNRELEASEDIRSRC=
SET SVNRELEASEURLSRC=
SET SVNRELEASEDIRBIN=
SET SVNRELEASEURLBIN=
SET SVNRELEASEDIRLOGPRODUCT=
SET SVNRELEASEURLLOGPRODUCT=
SET SVNRELEASEDIRLOG=
SET SVNLIBRELEASEDIRBIN=
SET ZWUTILDIR=
SET ZWUTILURL=
SET oldsvnrevision=
SET svnrevision=
SET util_version=
SET library_version=
SET release_version=
SET release_name=
SET APPDIR=
SET APPBRANCH=
SET LIBBRANCHDIR=
SET UTILBRANCHDIR=
SET APPBRANCHDIR=
SET APPVERSOURCEFILE=
SET APPVERSIONDEFINE=
SET APPREVISIONDEFINE=
SET TortoiseSVN=
SET CLISVN=
SET OLDVERSIONDIR=
SET OLDVERSION=
SET LATESTVERSION=
SET NEWVERSIONMAJOR=
SET NEWVERSIONMINOR=
