/********************************  EEPROM.H  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Internal EEPROM address definitions
 *
 * Author:   Peter Shorty
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 2256 $
 * Last Changed:     $Date: 2002-05-07 11:00:47 +0200 (ti, 07 maj 2002) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* EEPROM address definitions */

/* EEPROM LED dimmer node layout */
#define EEOFFSET_LEVEL              0x00
#define EEOFFSET_STATUS             EEOFFSET_LEVEL + 1
#define EEOFFSET_IGNORE_ALL_ON_OFF  EEOFFSET_LEVEL + 2
#define EEOFFSET_PROTECTED          EEOFFSET_LEVEL + 3
#define EEOFFSET_MAGIC              EEOFFSET_LEVEL + 4  /* MAGIC */

/* Default values */
#define DEFAULT_LEVEL               99    /* Full light level */
#define DEFAULT_STATUS              0
#define DEFAULT_IGNORE_ALL_ON_OFF   0
#define DEFAULT_PROTECTED           0
#define MAGIC_VALUE                 0x42


#endif /* _EEPROM_H_ */
