/*******************************  ZW_usb_api.h  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2007
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Header file to physical-layer functions/macros to the ASIC
 *
 * Author:  Samer Seoud
 *
 * Last Changed By:  $Author: ani $
 * Revision:         $Revision: 17765 $
 * Last Changed:     $Date: 2010-05-31 10:26:34 +0200 (Mon, 31 May 2010) $
 *
 ****************************************************************************/


#ifndef _ZW_USB_API_H_
#define _ZW_USB_API_H_

#define USB_EP1_RX_INT        0x80
#define USB_EP2_RX_INT        0x40
#define USB_EP1_TX_INT        0x10
#define USB_EP2_TX_INT        0x08
#define USB_SUSPEND_INT       0x04
#define USB_SOFTRESET_INT     0x02
#define USB_RESET_INT         0x01


/*===============================   ZW_USB_init   =============================
**  Initialize the usb interface
**--------------------------------------------------------------------------*/
void ZW_USB_init(
                 WORD vendorID,  /*the usb vendor ID 16-bit value*/
                 WORD productID,  /*the usb product ID id 16-bit value*/
                 WORD deviceBCD,  /*the device release number in BCD format*/
                 BYTE epNum);

/*===============================   ZW_USB_Disable   =============================
**  Disable the usb interface
**--------------------------------------------------------------------------*/
void
ZW_USB_disable();

/*===============================   ZW_USB_int_enable   =============================
**  Enable/Disable the USB interrupt
**--------------------------------------------------------------------------*/
void
ZW_USB_int_enable( BYTE intEnable  /*IN true if USB interrupt should be enabled else FALSE*/
                 );

/*===============================   ZW_USB_int_src_enable   =============================
**  Enable one or more of the usb interrupt sources
**  USB interrupt can have one or more of the following sources
**  USB_EP1_TX_INT
**  USB_EP2_TX_INT
**  USB_EP1_TX_INT
**  USB_EP1_TX_INT
**  USB_SOFT_RESET_INT
**  USB_RESET_INT
**  USB_SUSPEND_INT
**
**  Note: interrupt sources can be polled wihtout enabling the USB ISR
**        Wiht done by enbaling the interrupt sources by calling ZW_USB_int_src_enable
**        and polling them by calling ZW_USB_int_src_get
**-------------------------------------------------------------------------------------*/
void
ZW_USB_int_src_enable( BYTE intSrcMask);    /*IN a bit mask to specifiy the USB interrupt sources*/
                                          /* A bit field of value 1 indicates the interrupt source is enabled*/
/*===============================   ZW_USB_int_src_get   =============================
** Read the source of the usb interrupt
**  USB interrupt can have one or more of the following sources
**  USB_EP1_TX_INT
**  USB_EP2_TX_INT
**  USB_EP1_TX_INT
**  USB_EP1_TX_INT
**  USB_SOFT_RESET_INT
**  USB_RESET_INT
**  USB_SUSPEND_INT
**--------------------------------------------------------------------------*/

BYTE   /*RET a bit mask that indicates the source of the usb interrupt*/
ZW_USB_int_src_get();

/*===============================   ZW_USB_int_src_clear   =============================
** Clear the USB interrupt source
**  USB interrupt can have one or more of the following sources
**  USB_EP1_TX_INT
**  USB_EP2_TX_INT
**  USB_EP1_TX_INT
**  USB_EP1_TX_INT
**  USB_SOFT_RESET_INT
**  USB_RESET_INT
**  USB_SUSPEND_INT
**--------------------------------------------------------------------------*/
void   /*RET nothing*/
ZW_USB_int_src_clear(BYTE intSrcMask); /*IN the masks of the interrupts to be cleared*/

/*===============================   ZW_USB_ep1_write   =============================
** Write data to end point 1
**--------------------------------------------------------------------------*/
BYTE   /*RET the actual number of data written to the endpoint*/
ZW_USB_ep1_write(
           BYTE *buffer, /*IN address to the data we want to write it to the end point*/
           BYTE len );    /*IN the length of the data to be written to the endpoint*/


/*===============================   ZW_USB_ep2_write   =============================
** Write data to end point 2
**--------------------------------------------------------------------------*/
BYTE   /*RET the actual number of data written to the endpoint*/
ZW_USB_ep2_write(
           BYTE *buffer, /*IN address to the data we want to write it to the end point*/
           BYTE len );    /*IN the length of the data to be written to the endpoint*/

/*===============================   ZW_USB_ep1_read   =============================
** Read data from end point 1
**--------------------------------------------------------------------------*/

BYTE   /*RET the actual number of data read from the endpoint*/
ZW_USB_ep1_read(
           BYTE *buffer, /*IN address to the data buffer we want to copy data to it */
           BYTE len );    /*IN the length of the data to be read from the endpoint*/


/*===============================   ZW_USB_ep2_read   =============================
** Read data from end point 2
**--------------------------------------------------------------------------*/

BYTE   /*RET the actual number of data read from the endpoint*/
ZW_USB_ep2_read(
           BYTE *buffer, /*IN address to the data buffer we want to copy data to it */
           BYTE len );    /*IN the length of the data to be read from the endpoint*/

#endif /*_ZW_USB_API_H_*/
