/*******************************  ZW_spi_api.h  ****************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Interface driver for the built-in SPI controller
 *
 * Author:   Morten Vested Olesen
 *
 * Last Changed By:  $Author: sse $
 * Revision:         $Revision: 9286 $
 * Last Changed:     $Date: 2007-09-11 16:13:14 +0200 (Tue, 11 Sep 2007) $
 *
 ****************************************************************************/
#ifndef _ZW_SPI_API_H_
#define _ZW_SPI_API_H_
/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
#ifdef ZW030x
/* SPI clock speed */
#define SPI_SPEED_4_MHZ      0x00
#define SPI_SPEED_2_MHZ      0x01
#define SPI_SPEED_1_MHZ      0x02

/*spi signaling mode */
#define  SPI_SIG_MODE_1   0x00      /*(spi clock idle low, data sampled at rising edge and clocked at falling edge)*/
#define  SPI_SIG_MODE_2   0x04      /*(spi clock idle low, data sampled at falling edge and clocked at rising edge)*/
#define  SPI_SIG_MODE_3   0x08      /*(spi clock idle high, data sampled at falling edge and clocked at rising edge)*/
#define  SPI_SIG_MODE_4   0x0C      /*(spi clock idle high, data sampled at rising edge and clocked at falling edge)*/

/* data order */
#define SPI_MSB_FIRST      0x10
#define SPI_LSB_FIRST      0x00

/* master/slave */
#define SPI_MASTER         0x20
#define SPI_SLAVE          0x00

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*==============================   ZW_SPI_coll_get   ==============================
**    This function returns the state of the SPI collision flag
**
**    Side effects: clears the collision flag after it has been read
**--------------------------------------------------------------------------*/
BYTE   /*RET  Byte with state bit mask */
ZW_SPI_coll_get(void); /*IN  Nothing */

/*==============================  ZW_SPI_active_get   ==============================
**   Returns the active state is the SPI1 controller
**
**--------------------------------------------------------------------------*/

BYTE /* RET  zero (0x00): SPI1 is idle, non-zero: SPI is active. */
ZW_SPI_active_get(void);


/*==============================   ZW_SPI_enable   ==============================
**    Enable the SPI interface
**
**--------------------------------------------------------------------------*/
void   /*RET Nothing */
ZW_SPI_enable(BOOL bState); /*IN  TRUE: enable SPI1, FALSE: disable SPI */

/*===============================   ZW_SPI_init   ==============================
**    ZW_SPI1_init the SPI interface
**
**    Parameters:
**
**      bSpiInit IN: Bit mask that defines the setting of the spi controller
**
**        Speed of the SPI clock (master only)
**                - SPI_SPEED_8_MHZ
**                - SPI_SPEED_4_MHZ
**                - SPI_SPEED_2_MHZ
**                - SPI_SPEED_1_MHZ
**        SPI signaling modes
**                - SPI_SIG_MODE_1   (spi clock idle low, data sampled at rising edge and clocked at falling edge)
**                - SPI_SIG_MODE_2   (spi clock idle low, data sampled at falling edge and clocked at rising edge)
**                - SPI_SIG_MODE_3   (spi clock idle high, data sampled at falling edge and clocked at rising edge)
**                - SPI_SIG_MODE_4   (spi clock idle high, data sampled at rising edge and clocked at falling edge)
**        Data order
**                - SPI_MSB_FIRST (send MSB bit first)
**                - SPI_LSB_FIRST (Send LSB bit first)
**
**
** Side effects: Enables the SPI controller
**
**--------------------------------------------------------------------------*/
void                /*RET  Nothing        */
ZW_SPI_init(BYTE bSpiInit);    /*IN: bit mask that define the setting of the spi controller*/

/*===============================   ZW_SPI_rx_get   ==============================
**    Returns a received byte from the Serial Peripheral Interface
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE               /*RET  Received SPI data        */
ZW_SPI_rx_get( void );   /*IN   Nothing        */

/*===============================   ZW_SPI_tx_set  ==============================
**    This functions waits until the SPI is idle, then it writes a byte to the
**    SPI1 transmit register. It will start to transmit the data and the
**    function will return immediatly after the transmission is started.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void          /*RET  Nothing        */
ZW_SPI_tx_set(
BYTE bData);   /*IN   SPI data to be transmitted       */

#endif /*ZW030x*/
#ifdef ZW040x
/* SPI clock speed */
#define SPI_SPEED_8_MHZ      0x00
#define SPI_SPEED_4_MHZ      0x01
#define SPI_SPEED_2_MHZ      0x02
#define SPI_SPEED_1_MHZ      0x03

/*spi signaling mode */
#define  SPI_SIG_MODE_1   0x00 /*(spi clock idle low, data sampled at rising edge and clocked at falling edge)*/
#define  SPI_SIG_MODE_2   0x04 /*(spi clock idle low, data sampled at falling edge and clocked at rising edge)*/
#define  SPI_SIG_MODE_3   0x08     /*(spi clock idle high, data sampled at falling edge and clocked at rising edge)*/
#define  SPI_SIG_MODE_4   0x0C     /*(spi clock idle high, data sampled at rising edge and clocked at falling edge)*/

/* data order */
#define SPI_MSB_FIRST      0x10
#define SPI_LSB_FIRST      0x00

/* master/slave */
#define SPI_MASTER         0x20
#define SPI_SLAVE          0x00

/* slave select */
#define SPI_SS_N_SS        0x08
#define SPI_SS_N_GPIO      0x00

/*Value for maximum data size to check*/
#define MAX_DATA_FLASH_CHECK 30


/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*==============================   ZW_SPI1_int_clear   ==============================
**    This function clears the SPI1 interface interrupt flag
**
**--------------------------------------------------------------------------*/
void   /*RET Nothing */
ZW_SPI1_int_clear(void); /*IN  Nothing */

/*==============================   ZW_SPI1_coll_get   ==============================
**    This function returns the state of the SPI1 collision flag
**
**    Side effects: clears the collision flag after it has been read
**--------------------------------------------------------------------------*/
BYTE   /*RET  Byte with state bit mask */
ZW_SPI1_coll_get(void); /*IN  Nothing */

/*==============================  ZW_SPI1_active_get   ==============================
**   Returns the active state is the SPI1 controller
**
**--------------------------------------------------------------------------*/

BYTE /* RET  zero (0x00): SPI1 is idle, non-zero: SPI1 is active. */
ZW_SPI1_active_get(void);

/*==============================  ZW_SPI1_int_get   ==============================
**   Returns the state of the SPI1 interrupt flag
**
**--------------------------------------------------------------------------*/

BYTE /* RET  zero (0x00): interrupt flag is not set , none-zero: Interrupt flag is set . */
ZW_SPI1_int_get(void);


/*==============================   ZW_SPI1_enable   ==============================
**    Enable the SPI interface
**
**--------------------------------------------------------------------------*/
void   /*RET Nothing */
ZW_SPI1_enable(BOOL bState); /*IN  TRUE: enable SPI1, FALSE: disable SPI1 */

/*===============================   ZW_SPI1_init   ==============================
**    ZW_SPI1_init the SPI interface
**
**    Parameters:
**
**      bSpiInit IN: Bit mask that defines the setting of the spi controller
**
**        Speed of the SPI clock (master only)
**                - SPI_SPEED_8_MHZ
**                - SPI_SPEED_4_MHZ
**                - SPI_SPEED_2_MHZ
**                - SPI_SPEED_1_MHZ
**        SPI signaling modes
**                - SPI_SIG_MODE_1   (spi clock idle low, data sampled at rising edge and clocked at falling edge)
**                - SPI_SIG_MODE_2   (spi clock idle low, data sampled at falling edge and clocked at rising edge)
**                - SPI_SIG_MODE_3   (spi clock idle high, data sampled at falling edge and clocked at rising edge)
**                - SPI_SIG_MODE_4   (spi clock idle high, data sampled at rising edge and clocked at falling edge)
**        Data order
**                - SPI_MSB_FIRST (send MSB bit first)
**                - SPI_LSB_FIRST (Send LSB bit first)
**
**
** Side effects: Enables the SPI controller
**
**--------------------------------------------------------------------------*/
void                /*RET  Nothing        */
ZW_SPI1_init(BYTE bSpiInit);    /*IN: bit mask that define the setting of the spi controller*/

/*===============================   ZW_SPI1_rx_get   ==============================
**    Returns a received byte from the Serial Peripheral Interface
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE               /*RET  Received SPI data        */
ZW_SPI1_rx_get( void );   /*IN   Nothing        */

/*===============================   ZW_SPI1_tx_set  ==============================
**    This functions waits until the SPI1 is idle, then it writes a byte to the
**    SPI1 transmit register. It will start to transmit the data and the
**    function will return immediatly after the transmission is started.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void          /*RET  Nothing        */
ZW_SPI1_tx_set(
BYTE bData);   /*IN   SPI data to be transmitted       */

/*==============================   ZW_SPI0_int_clear   ==============================
**    This function clears the SPI0 interface interrupt flag
**
**--------------------------------------------------------------------------*/
void   /*RET Nothing */
ZW_SPI0_int_clear(void); /*IN  Nothing */

/*==============================   ZW_SPI0_coll_get   ==============================
**    This function returns the state of the SPI0 collision flag
**
**    Side effects: clears the collision flag after it has been read
**--------------------------------------------------------------------------*/
BYTE   /*RET  Byte with state bit mask */
ZW_SPI0_coll_get(void); /*IN  Nothing */

/*==============================  ZW_SPI0_active_get   ==============================
**   Returns the active state is the SPI0 controller
**
**--------------------------------------------------------------------------*/

BYTE /* RET  zero (0x00): SPI0 is idle, non-zero: SPI0 is active. */
ZW_SPI0_active_get(void);

/*==============================  ZW_SPI0_int_get   ==============================
**   Returns the state of the SPI0 interrupt flag
**
**--------------------------------------------------------------------------*/

BYTE /* RET  zero (0x00): interrupt flag is not set , none-zero: Interrupt flag is set . */
ZW_SPI0_int_get(void);


/*==============================   ZW_SPI0_enable   ==============================
**    Enable the SPI interface
**
**--------------------------------------------------------------------------*/
void   /*RET Nothing */
ZW_SPI0_enable(BOOL bState); /*IN  TRUE: enable SPI0, FALSE: disable SPI0 */

/*===============================   ZW_SPI0_init   ==============================
**    ZW_SPI0_init the SPI interface
**
**    Parameters:
**
**      bSpiInit IN: Bit mask that defines the setting of the spi controller
**
**        Speed of the SPI clock (master only)
**                - SPI_SPEED_8_MHZ
**                - SPI_SPEED_4_MHZ
**                - SPI_SPEED_2_MHZ
**                - SPI_SPEED_1_MHZ
**        SPI signaling modes
**                - SPI_SIG_MODE_1   (spi clock idle low, data sampled at rising edge and clocked at falling edge)
**                - SPI_SIG_MODE_2   (spi clock idle low, data sampled at falling edge and clocked at rising edge)
**                - SPI_SIG_MODE_3   (spi clock idle high, data sampled at falling edge and clocked at rising edge)
**                - SPI_SIG_MODE_4   (spi clock idle high, data sampled at rising edge and clocked at falling edge)
**        Data order
**                - SPI_MSB_FIRST (send MSB bit first)
**                - SPI_LSB_FIRST (Send LSB bit first)
**        Master/slave
**                - SPI_MASTER (use SPI master mode)
**                - SPI_SLAVE (use SPI slave mode)
**        Slave select
**                - SPI_SS_N_SS (use io SS_N as the slave select when the ZW040x is a SPI slave)
**                - SPI_SS_N_GPIO (use SS_N as normal GPIO or for other functions)
**
**
** Side effects: Enables the SPI controller
**
**--------------------------------------------------------------------------*/
void                /*RET  Nothing        */
ZW_SPI0_init(BYTE bSpiInit);    /*IN: bit mask that define the setting of the spi controller*/

/*===============================   ZW_SPI0_rx_get   ==============================
**    Returns a received byte from the Serial Peripheral Interface
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE               /*RET  Received SPI data        */
ZW_SPI0_rx_get( void );   /*IN   Nothing        */

/*===============================   ZW_SPI0_tx_set  ==============================
**    This functions waits until the SPI0 is idle, then it writes a byte to the
**    SPI0 transmit register. It will start to transmit the data and the
**    function will return immediatly after the transmission is started.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void          /*RET  Nothing        */
ZW_SPI0_tx_set(BYTE bData);   /*IN   SPI data to be transmitted       */



#endif /*ZW040x*/

#endif /* _ZW_SPI_API_H_ */
