/********************************  ZW_RF040X.H  *****************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Application flash ROM RF table offset
 *
 * Author:   Samer Seoud
 *
 * Last Changed By:  $Author: sse $
 * Revision:         $Revision: 10862 $
 * Last Changed:     $Date: 2008-08-04 16:27:12 +0200 (Mon, 04 Aug 2008) $
 *
 ****************************************************************************/
#ifndef _ZW_RF040X_H_
#define _ZW_RF040X_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/


#define RF_MAGIC_VALUE          0x42

/* Valid values for FLASH_FREQ */
 /* EU frequency (868.42MHz) */
#define RF_EU                    0
 /* US frequency (908.42MHz) */
#define RF_US                    1
 /* Autsralia/Newzealand frequency (921.42MHz) */
#define RF_ANZ                   2
 /* hongkong frequency (919.82MHz) */
#define RF_HK                    3
 /* Maylasyia frequency (868.2MHz) */
#define RF_MY                    8

/* Indian frequency (865.22MHz) */
#define RF_IN                    9

 /* Japan frequency (920.1MHz) */
#define RF_JP                    10

/* Japan frequency (951.1MHz) */
#define RF_JP_950                25

/*Russia Frequencu*/
#define RF_RU              26

/* Use default defined in Z-WAVE lib */
#define APP_DEFAULT_NORM_POWER  0xFF
/* Use default defined in Z-WAVE lib */
#define APP_DEFAULT_LOW_POWER   0xFF
/* Application RF const table offsets */

/* Application RF const table fixed adress in flash ROM - DON'T CHANGE THIS!!! */
#define FLASH_APPL_TABLE_OFFSET 0xFFB0

/* Normal power setting offset */
#define FLASH_APPL_NORM_POWER_OFFS_0   2
#define FLASH_APPL_NORM_POWER_OFFS_1   3
#define FLASH_APPL_NORM_POWER_OFFS_2   4
/* Low power setting offset */
#define FLASH_APPL_LOW_POWER_OFFS_0    5
#define FLASH_APPL_LOW_POWER_OFFS_1    6
#define FLASH_APPL_LOW_POWER_OFFS_2    7

#endif
