/*******************************  ZW_PORTPIN_API.H  *************************
 *
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001-2011
 *              Sigma Designs, Inc.
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Sigma Designs Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: ZW040x Port Pin service functions module include
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 18221 $
 * Last Changed:     $Date: 2010-07-12 14:28:35 +0200 (ma, 12 jul 2010) $
 *
 ****************************************************************************/
#ifndef _ZW_PORTPIN_API_H_
#define _ZW_PORTPIN_API_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

typedef enum
{
  PORTPIN_P0B0  = 0x80,
  PORTPIN_P0B1  = 0x81,
  PORTPIN_P0B2  = 0x82,
  PORTPIN_P0B3  = 0x83,
  PORTPIN_P0B4  = 0x84,
  PORTPIN_P0B5  = 0x85,
  PORTPIN_P0B6  = 0x86,
  PORTPIN_P0B7  = 0x87,

  PORTPIN_P1B0  = 0x90,
  PORTPIN_P1B1  = 0x91,
  PORTPIN_P1B2  = 0x92,
  PORTPIN_P1B3  = 0x93,
  PORTPIN_P1B4  = 0x94,
  PORTPIN_P1B5  = 0x95,
  PORTPIN_P1B6  = 0x96,
  PORTPIN_P1B7  = 0x97,

  PORTPIN_P2B0  = 0xA0,
  PORTPIN_P2B1  = 0xA1,
  PORTPIN_P2B2  = 0xA2,
  PORTPIN_P2B3  = 0xA3,
  PORTPIN_P2B4  = 0xA4,
  PORTPIN_P2B5  = 0xA5,
  PORTPIN_P2B6  = 0xA6,
  PORTPIN_P2B7  = 0xA7,

  PORTPIN_P3B0  = 0xB0,
  PORTPIN_P3B1  = 0xB1,
  PORTPIN_P3B2  = 0xB2,
  PORTPIN_P3B3  = 0xB3,
  PORTPIN_P3B4  = 0xB4,
  PORTPIN_P3B5  = 0xB5,
  PORTPIN_P3B6  = 0xB6,
  PORTPIN_P3B7  = 0xB7
} ENUM_PORTPINS;


/*==============================   ZW_PortPinSet   ===========================
** Function used to set Level on a specific Port pin using bPortPin
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void
ZW_PortPinSet(
  ENUM_PORTPINS bPortPin,
  BOOL bVal);


/*==============================   ZW_PortPinGet   ===========================
** Function used to get Level on a specific Port pin using bPortPin
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BOOL
ZW_PortPinGet(
  ENUM_PORTPINS bPortPin);


/*===============================   ZW_PortPinIn   ===========================
**    Setup bPortPin portpin as Input
**
**--------------------------------------------------------------------------*/
void
ZW_PortPinIn(
  ENUM_PORTPINS bPortPin);


/*===============================   ZW_PortPinOut   ==========================
**    Setup bPortPin portpin as Output
**
**--------------------------------------------------------------------------*/
void
ZW_PortPinOut(
  ENUM_PORTPINS bPortPin);

#endif
