$GEN
;******************************  ZW_PATCH.INC  ******************************
;*           #######
;*           ##  ##
;*           #  ##    ####   #####    #####  ##  ##   #####
;*             ##    ##  ##  ##  ##  ##      ##  ##  ##
;*            ##  #  ######  ##  ##   ####   ##  ##   ####
;*           ##  ##  ##      ##  ##      ##   #####      ##
;*          #######   ####   ##  ##  #####       ##  #####
;*                                           #####
;*          Z-Wave, the wireless lauguage.
;*
;*              Copyright (c) 2001
;*              Zensys A/S
;*              Denmark
;*
;*              All Rights Reserved
;*
;*    This source file is subject to the terms and conditions of the
;*    Zensys Software License Agreement which restricts the manner
;*    in which it may be used.
;*
;*---------------------------------------------------------------------------
;*
;* Description: Z-Wave ZW_Patchcheck:
;*    Walk through the table of patches, and check if there is a match.
;*    If there is a match, execute the patch function instead of the
;*    original function.
;*
;*    This include file defines the MACROs for insertion in the very first
;*    beginning of ROM'ed functions, which should be patchable, and in the very
;*    first beginning of RAM'ed patch functions.
;*
;* Author:   Erik Friis Harck
;*
;* Last Changed By:  $Author: efh $
;* Revision:         $Revision: 9763 $
;* Last Changed:     $Date: 2008-01-10 11:28:42 +0100 (Thu, 10 Jan 2008) $
;*
;****************************************************************************/
#ifndef _ZW_PATCH_INC_
#define _ZW_PATCH_INC_

;/****************************************************************************/
;/*                     EXPORTED TYPES and DEFINITIONS                       */
;/****************************************************************************/

$IF (MAKE_PATCHABLE_CODE)

  EXTRN CODE  (ZW_Patchcheck)

;*======== Macro definition for making a function patchable ===============
PATCHCHECK      MACRO FUNCTIONNAME
	LCALL	ZW_Patchcheck
_?Return_&FUNCTIONNAME&:
	PUBLIC	_?Return_&FUNCTIONNAME
                ENDM

$ELSE ;* MAKE_PATCHABLE_CODE

?CO?ZW_PATCHTABLE    SEGMENT 'CODE_PATCH'

;*======== Macro definition for making a function a patch function ========
PATCHFUNCTION   MACRO FUNCTIONNAME, MODULENAME
_?Continue_&FUNCTIONNAME&:
	PUBLIC	_?Continue_&FUNCTIONNAME
	RSEG  ?CO?ZW_PATCHTABLE
  EXTRN CODE  (_?Return_&FUNCTIONNAME)
  DW  _?Return_&FUNCTIONNAME&,_?Continue_&FUNCTIONNAME
	RSEG  ?PR?_?Patch_&FUNCTIONNAME&?&MODULENAME
                ENDM

$ENDIF ;* MAKE_PATCHABLE_CODE

#endif /* _ZW_PATCH_INC_ */
