/*******************************  ZW_PATCH.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Z-Wave ZW_Patchcheck:
 *    Walk through the table of patches, and check if there is a match.
 *    If there is a match, execute the patch function instead of the
 *    original function.
 *
 * Author:   Erik Friis Harck
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 9763 $
 * Last Changed:     $Date: 2008-01-10 11:28:42 +0100 (Thu, 10 Jan 2008) $
 *
 ****************************************************************************/
#ifndef _ZW_PATCH_H_
#define _ZW_PATCH_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

#ifdef PATCH_ENABLE
#if defined(STARTER_PATCH)
#define PATCH_FUNCTION_NAME(name) name
#define PATCH_FUNCTION_NAME_STARTER(name) name##_Wrapped
#define PATCH_FUNCTION_NAME_WRAPPER(name) Patch_##name
#define PATCH_TABLE_ENTRY(func)
#define PATCH_TABLE_ENTRY_STARTER(func)
#define PATCH_TABLE_ENTRY_WRAPPER(func) PATCHFUNCTION func, MODULENAME
#define PATCH_VARIABLE
#define PATCH_VARIABLE_STARTER extern
#endif
#if defined(WORK_PATCH)
#define PATCH_FUNCTION_NAME(name) Patch_##name
#define PATCH_FUNCTION_NAME_STARTER(name) Patch_##name
#define PATCH_FUNCTION_NAME_WRAPPER(name) Patch_##name
#define PATCH_TABLE_ENTRY(func) PATCHFUNCTION func, MODULENAME
#define PATCH_TABLE_ENTRY_STARTER(func) PATCHFUNCTION func, MODULENAME
#define PATCH_TABLE_ENTRY_WRAPPER(func) PATCHFUNCTION func, MODULENAME
#define PATCH_VARIABLE extern
#define PATCH_VARIABLE_STARTER extern
#endif
#if !(defined(WORK_PATCH) || defined(STARTER_PATCH))
#define PATCH_FUNCTION_NAME(name) name
#define PATCH_FUNCTION_NAME_STARTER(name) name
#define PATCH_FUNCTION_NAME_WRAPPER(name) name
#define PATCH_TABLE_ENTRY(func) PATCHCHECK func
#define PATCH_TABLE_ENTRY_STARTER(func) PATCHCHECK func
#define PATCH_TABLE_ENTRY_WRAPPER(func) PATCHCHECK func
#define PATCH_VARIABLE
#define PATCH_VARIABLE_STARTER
#endif
#else
#define PATCH_FUNCTION_NAME(name) name
#define PATCH_FUNCTION_NAME_STARTER(name) name
#define PATCH_FUNCTION_NAME_WRAPPER(name) name
#define PATCH_VARIABLE
#define PATCH_VARIABLE_STARTER
#endif

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
/*===============================   ZW_Patchcheck   ==========================
**    Walk through the table of patches.
**
**--------------------------------------------------------------------------*/
extern void               /*RET Nothing    */
ZW_Patchcheck(void);

/*===========================   ZW_PatchcheckInit   ==========================
**    Check the checksum of the table of patches.
**
**--------------------------------------------------------------------------*/
extern void              /*RET  nothing               */
ZW_PatchcheckInit(void);

#endif /* _ZW_PATCH_H_ */
