/*******************************  ZW_NVM_ADDR.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Application NVM start address
 *
 * Author:   Peter Shorty
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 14376 $
 * Last Changed:     $Date: 2009-06-29 14:04:16 +0200 (Mon, 29 Jun 2009) $
 *
 ****************************************************************************/
#ifndef _ZW_NVM_ADDR_H_
#define _ZW_NVM_ADDR_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* Set defines for the type of NVM used */

#ifdef ZW_AVREMOTE
#define NVM_IS_FLASH
#endif

#ifdef ZW_CONTROLLER
#define NVM_IS_EEPROM
#endif /* ZW_CONTROLLER */

#ifdef ZW_SLAVE
#ifdef ZW_SLAVE_32
#define NVM_IS_EEPROM
#else /* ZW_SLAVE_32 */
#define NVM_IS_FLASH
#define NVM_IS_MTP
#endif /* ZW_SLAVE_32 */
#endif /* ZW_SLAVE */


/* Define NVM application start address */

#ifdef NVM_IS_FLASH
#ifdef ZW_SLAVE_ROUTING
#ifndef ZW_SLAVE_SENSOR
/* Plain routing slave */
#define NVM_APPL_OFFSET    52
#else
#define NVM_APPL_OFFSET    58
#endif

#else /* !ZW_SLAVE_ROUTING */
#define NVM_APPL_OFFSET    10
#endif /* ZW_SLAVE_ROUTING */
#endif /* NVM_IS_FLASH */


#ifdef NVM_IS_EEPROM
#if defined(ZW_SLAVE_32) && !defined(ZW_SLAVE_ENHANCED_232)
#define NVM_APPL_OFFSET    0x120
#endif  /* defined(ZW_SLAVE_32) && !defined(ZW_SLAVE_ENHANCED_232) */
#ifdef ZW_SLAVE_ENHANCED_232
#define NVM_APPL_OFFSET    0x1200
#endif  /* ZW_SLAVE_ENHANCED_232 */


#ifdef ZW_CONTROLLER
#ifdef ZW_CONTROLLER_STATIC
#define NVM_APPL_OFFSET    0x2C00
#else
#define NVM_APPL_OFFSET    0x2500
#endif
#endif /* ZW_CONTROLLER */
#endif /* NVM_IS_EEPROM */

#endif /* _ZW_NVM_ADDR_H_ */
