/*******************************  ZW_non_zero.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: This module define an address range in XRAM reserved for uninitialized variables.
 *
 * Author:   Samer Seoud
 *
 * Last Changed By:  $Author: sse $
 * Revision:         $Revision: 15334 $
 * Last Changed:     $Date: 2009-10-22 16:13:31 +0200 (Thu, 22 Oct 2009) $
 *
 ****************************************************************************/
#ifndef _ZW_NON_ZERO_H_
#define _ZW_NON_ZERO_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
#ifdef ZW040x
#define XDATA_LENGTH	0x1000
#define NON_ZERO_SIZE    64
#define NON_ZERO_START_ADDR   0x1200
#endif

#ifdef ZW030x
#define XDATA_LENGTH	0x800
#ifdef ZW_SLAVE
#define NON_ZERO_SIZE    256
#else
#define NON_ZERO_SIZE    16
#endif
#define NON_ZERO_START_ADDR   (XDATA_LENGTH-NON_ZERO_SIZE)
#endif /*ZW030x*/

#endif /* _ZW_NON_ZERO_H_ */
