/************************* ZW_keypad_scanner_api.h ************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Products that speak Z-Wave work together better
 *
 *              Copyright (c) 2008
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: This file contains definitions of the 400 series keypad
 *              scanner functions and macros
 *
 * Author:   Morten Vested Olesen
 *
 * Last Changed By:  $Author: mvo $
 * Revision:         $Revision: 1.5 $
 * Last Changed:     $Date: 2007/02/05 21:14:30 $
 *
 ****************************************************************************/

#ifndef _ZW_KEYPAD_SCANNER_API_H_
#define _ZW_KEYPAD_SCANNER_API_H_
/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
#define ZW_KS_KEYPRESS_VALID    0x01
#define ZW_KS_KEYPRESS_INVALID  0x02
#define ZW_KS_KEYPRESS_RELEASED 0x03

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*=========================   ZW_KEYPAD_init     ============================
**    Initialize Keypad Scanner
**
**    Side effects: Disables keypad scanner
**--------------------------------------------------------------------------*/
void           /*RET Nothing */
ZW_KS_init(BYTE bCols,          /* IN Number of Columns
                                            0:  1 column
                                            1:  2 columns
                                                  :
                                           15: 16 columns     */
           BYTE bScanDelay,     /* IN Column scan delay (0-15)
                                            0:   2ms
                                            1:   4ms
                                                 :
                                            15: 32ms  */
           BYTE bDebounceDelay, /* IN Debounce delay
                                            0:   2ms
                                            1:   4ms
                                                 :
                                            15: 32ms  */
           BYTE bStableDelay,   /* IN Row Stable delay
                                            0:   2ms
                                            1:   4ms
                                                 :
                                            15: 32ms  */
           BYTE bReportWaitTimeout,   /* IN timeout value in (10 * ms) to
                                           wait before reporting keys changes*/
           VOID_CALLBACKFUNC(KeyPadCallBack)(BYTE_P pbKeyMatrix, BYTE bStatus)
           );

/*=========================   ZW_KEYPAD_enable     ============================
**    Enable/disable Keypad Scanner
**
**--------------------------------------------------------------------------*/
void           /*RET Nothing */
ZW_KS_enable(BYTE enable);     /* IN TRUE: to enable the keypad Scanner,
                                *    FALSE: to disable it*/

/*=========================    ZW_KS_pd_enable   ============================
**    Enable/disable Keypad Scanner powerdown mode
**    Side effects:
**--------------------------------------------------------------------------*/
void           /*RET Nothing */
ZW_KS_pd_enable(BOOL boEnable); /* IN TRUE: enable power down mode of Keypad Scanner,
                                 *    FALSE: disable power down mode Keypad Scanner */


#endif /*_ZW_KEYPAD_SCANNER_API_H_*/
