/****************************************************************************
 *
 * Copyright (c) 2001-2011
 * Sigma Designs, Inc.
 * All Rights Reserved
 *
 *---------------------------------------------------------------------------
 *
 * Description:       Buffered transmit/receive of data through the UART
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 7079 $
 * Last Changed:     $Date: 2005-11-14 16:57:30 +0200 (Пн, 14 Лис 2005) $
 *
 ****************************************************************************/
#ifndef _UART_BUF_IO_H_
#define _UART_BUF_IO_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

#ifdef USBVCP
#define ZW_SerialCheck ZW_SerialCheck_udc
#define ZW_SerialGetByte ZW_SerialGetByte_udc
#define ZW_SerialPutByte ZW_SerialPutByte_udc
#define ZW_SerialFlush ZW_SerialFlush_udc
#define ZW_InitSerialIf ZW_InitSerialIf_udc
#else
#define ZW_SerialCheck ZW_SerialCheck_uart
#define ZW_SerialGetByte ZW_SerialGetByte_uart
#define ZW_SerialPutByte ZW_SerialPutByte_uart
#define ZW_SerialFlush ZW_SerialFlush_uart
#define ZW_InitSerialIf ZW_InitSerialIf_uart
#endif

BYTE ZW_SerialCheck(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;
BYTE ZW_SerialGetByte(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;
BYTE ZW_SerialPutByte(BYTE ch)
#ifdef PATCH_ENABLE
reentrant
#endif
;
void ZW_SerialFlush(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;
void ZW_InitSerialIf(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

#endif /* _UART_BUF_IO_H_ */
