/******************************* ZW_aes_api.h  ****************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Products that speak Z-Wave work together better
 *
 *              Copyright (c) 2008
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Interface driver for the 400 series built-in AES-128 cipher block.
 *
 * Author:   Morten Vested Olesen
 *
 * Last Changed By:  $Author: sse $
 * Revision:         $Revision: 11516 $
 * Last Changed:     $Date: 2008-10-15 11:07:14 +0200 (Wed, 15 Oct 2008) $
 *
 ****************************************************************************/
#ifndef _ZW_AES_API_H_
#define _ZW_AES_API_H_
/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/*============================   ZW_AES_ecb_set   =========================
**  Runs the AES in ECB mode (Eletronic Cookbook mode)
**
**  Side effects: Waits until the AES block is idle before starting
**--------------------------------------------------------------------------*/
void             /*RET Nothing */
ZW_AES_ecb_set(
  BYTE *bData,  /* IN  pointer to byte array containing the data (16 bytes)*/
  BYTE *bKey);   /* IN  pointer to byte array containing the  key (16 bytes) */

/*============================   ZW_AES_ecb_get   =========================
**  Reads result of AES run in ECB mode (Eletronic Cookbook mode)
**
**  Side effects:
**--------------------------------------------------------------------------*/
void             /*RET Nothing */
ZW_AES_ecb_get(
  BYTE *bData);  /* IN  pointer to byte array buffer to store data (16 bytes)*/

/*=============================   ZW_AES_enable ==========================
**  Enables or disables the AES
**
**  Side effects:
**--------------------------------------------------------------------------*/
void         /*RET Nothing */
ZW_AES_enable(BOOL bState); /* IN  TRUE: enables AES, FLASE: disables AES  */


/*=============================   ZW_AES_int_clear ==========================
**  Clears AES interrupt flag
**
**  Side effects:
**--------------------------------------------------------------------------*/
void         /*RET Nothing */
ZW_AES_int_clear(void); /* IN  Nothing */

/*=============================   ZW_AES_int_get ==========================
**  Returns the state of the AES interrupt flag
**
**  Side effects:
**--------------------------------------------------------------------------*/
BYTE         /*RET byte interrupt flag state */
ZW_AES_int_get(void); /* IN  Nothing */

/*=============================   ZW_AES_int_enable ==========================
**  Enables/disables AES interrupt
**
**  Side effects:
**--------------------------------------------------------------------------*/
void         /*RET Nothing */
ZW_AES_int_enable(BOOL bState); /* IN  byte interrupt enable state
                                 *     TRUE:  interrupt enabled
                                 *     FLASE: interrupt disabled */

/*=============================   ZW_AES_active_get ==========================
**  Returns the active state of the AES block
**
**  Side effects:
**--------------------------------------------------------------------------*/
BYTE         /*RET byte active flag state */
ZW_AES_active_get(void); /* IN  Nothing */

/*===============================   AES_ECB   ================================
**    AES ECB - Electronic CodeBook Mode Block
**
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern void
ZW_AES_ECB(
  BYTE *key,
  BYTE *inputDat,
  BYTE *outputDat)
;

#endif /* _ZW_AES_API_H_ */
