; /************************  ZW_PATCHTABLE_FOOTER.A51  ************************
;  *           #######
;  *           ##  ##
;  *           #  ##    ####   #####    #####  ##  ##   #####
;  *             ##    ##  ##  ##  ##  ##      ##  ##  ##
;  *            ##  #  ######  ##  ##   ####   ##  ##   ####
;  *           ##  ##  ##      ##  ##      ##   #####      ##
;  *          #######   ####   ##  ##  #####       ##  #####
;  *                                           #####
;  *          Z-Wave, the wireless language.
;  *
;  *              Copyright (c) 2001
;  *              Zensys A/S
;  *              Denmark
;  *
;  *              All Rights Reserved
;  *
;  *    This source file is subject to the terms and conditions of the
;  *    Zensys Software License Agreement which restricts the manner
;  *    in which it may be used.
;  *
;  *---------------------------------------------------------------------------
;  *
;  * Description: Z-Wave tableOfPatchedFunctions:
;  *    This table contains a NULL terminated list of pointer pairs for the
;  *    functions in ROM, for which we have a patch.
;  *    The table is immediatly followed by a footer of a fixed format and
;  *    which shall be located at a fixed address in the top of memory.
;  *
;  *    This module contains the footer for the tableOfPatchedFunctions,
;  *    and it has to be linked in as the very last module during linking
;  *    of the program under development, and to be loaded in executable RAM.
;  *    Linking in this footer after anything else assures that every entry
;  *    for the patchTable generated by the program compilation will be included
;  *    in the final patchTable during linking.
;  *
;  * Author:   Erik Friis Harck
;  *
;  * Last Changed By:  $Author: efh $
;  * Revision:         $Revision: 9763 $
;  * Last Changed:     $Date: 2008-01-10 11:28:42 +0100 (Thu, 10 Jan 2008) $
;  *
;  ****************************************************************************/
;

$NOMOD51

NAME	ZW_PATCHTABLE_FOOTER

?CO?ZW_PATCHTABLE    SEGMENT 'CODE_PATCH'

  EXTRN CODE  (InitVarsPatch)
  EXTRN CODE  (tableOfPatchedFunctions)
  PUBLIC      patchTableFooter

; /****************************************************************************/
; /*                      PRIVATE TYPES and DEFINITIONS                       */
; /****************************************************************************/
;
; typedef void (code * functionPointer)();
;
; typedef struct {
;   functionPointer originalFunction;
;   functionPointer patchFunction;
; } tsPatchTableEntry;
;
; typedef struct {
;   functionPointer endMarkerLow;
;   functionPointer endMarkerHigh;
;   functionPointer patchVariableInit;
; } tsPatchDescriptor;

; /****************************************************************************/
; /*                              EXPORTED DATA                               */
; /****************************************************************************/
;
; code tsPatchTableEntry tableOfPatchedFunctions[] = {
;   {Return_EnQueueSingleData, Continue_EnQueueSingleData},
;   .
;   .
;   .
;   {NULL, NULL}        /* Terminate the table with a NULL */
; };
; code tsPatchTableEntry patchTableFooter[] = {
;   /* The last entry shall contain a pointer to the start of this table */
;   /* and a checksum                                                    */
;   {tableOfPatchedFunctions, NULL}
; };
;
	RSEG  ?CO?ZW_PATCHTABLE

;/* Start with the function with the highest address, */
;/* and end with the function with the lowest address */
;;tableOfPatchedFunctions:
;;  EXTRN CODE  (_?Return_ApplicationInitHW,_?Continue_ApplicationInitHW)
;;  DW  _?Return_ApplicationInitHW,_?Continue_ApplicationInitHW
;;  EXTRN CODE  (_?Return_ApplicationInitSW,_?Continue_ApplicationInitSW)
;;  DW  _?Return_ApplicationInitSW,_?Continue_ApplicationInitSW
;;  EXTRN CODE  (_?Return_ApplicationTestPoll,_?Continue_ApplicationTestPoll)
;;  DW  _?Return_ApplicationTestPoll,_?Continue_ApplicationTestPoll
;;  EXTRN CODE  (_?Return_ApplicationPoll,_?Continue_ApplicationPoll)
;;  DW  _?Return_ApplicationPoll,_?Continue_ApplicationPoll
;;  EXTRN CODE  (_?Return_ApplicationCommandHandler,_?Continue_ApplicationCommandHandler)
;;  DW  _?Return_ApplicationCommandHandler,_?Continue_ApplicationCommandHandler
;;  EXTRN CODE  (_?Return_ApplicationSlaveUpdate,_?Continue_ApplicationSlaveUpdate)
;;  DW  _?Return_ApplicationSlaveUpdate,_?Continue_ApplicationSlaveUpdate
;;  EXTRN CODE  (_?Return_ApplicationNodeInformation,_?Continue_ApplicationNodeInformation)
;;  DW  _?Return_ApplicationNodeInformation,_?Continue_ApplicationNodeInformation
;	EXTRN	CODE (_?Return_EnQueueSingleData, _?Continue_EnQueueSingleData)
;	DW	_?Return_EnQueueSingleData + 0,_?Continue_EnQueueSingleData + 0

	DW	00000H,0FFFFH        ;/* Terminate the table with a NULL */
	DW	InitVarsPatch        ;/* Pointer to variable initialization function for patch */

patchTableFooter:
	DW	tableOfPatchedFunctions,00000H

	END
