/*******************************  ZW_EVALDEFS.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: IO definitions for the Z-Wave Evaluation board
 *
 * Author:   Ivar Jeppesen
 *
 * Last Changed By:  $Author: jsi $
 * Revision:         $Revision: 19442 $
 * Last Changed:     $Date: 2010-11-17 13:40:42 +0100 (Wed, 17 Nov 2010) $
 *
 ****************************************************************************/
#ifndef _ZW_EVALDEFS_H_
#define _ZW_EVALDEFS_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* Evaluation board LEDs */

/* Turn LED on/off
 *  led - LED number
 */


#define LED_ON(led)   PIN_OFF(LED##led)
#define LED_OFF(led)  PIN_ON(LED##led)

#define LED_TOGGLE(led) PIN_TOGGLE(LED##led)


/* LED number       Z-Wave Device pin */


#ifdef ZW040x
#ifdef HW_RF
#define LED1Port       P1
#define LED1SHADOW     P1Shadow
#define LED1SHADOWDIR  P1ShadowDIR
#define LED1DIR        P1DIR
#define LED1DIR_PAGE   P1DIR_PAGE
#define LED1           4

#define LEDZM4102_1Port       P1
#define LEDZM4102_1SHADOW     P1Shadow
#define LEDZM4102_1SHADOWDIR  P1ShadowDIR
#define LEDZM4102_1DIR        P1DIR
#define LEDZM4102_1DIR_PAGE   P1DIR_PAGE
#define LEDZM4102_1           4

#define LED2Port        P1
#define LED2SHADOW      P1Shadow
#define LED2SHADOWDIR   P1ShadowDIR
#define LED2DIR         P1DIR
#define LED2DIR_PAGE    P1DIR_PAGE
#define LED2            5

#define LED3Port       P1
#define LED3SHADOW     P1Shadow
#define LED3SHADOWDIR  P1ShadowDIR
#define LED3DIR_PAGE   P1DIR_PAGE
#define LED3           6

#define LED4Port        P1
#define LED4SHADOW      P1Shadow
#define LED4SHADOWDIR   P1ShadowDIR
#define LED4DIR         P1DIR
#define LED4DIR_PAGE    P1DIR_PAGE
#define LED4            7
#else
#define LED1Port        P0
#define LED1SHADOW      P0Shadow
#define LED1SHADOWDIR   P0ShadowDIR
#define LED1DIR         P0DIR
#define LED1DIR_PAGE    P0DIR_PAGE
#define LED1            7

#define LEDZM4102_1Port       P1
#define LEDZM4102_1SHADOW     P1Shadow
#define LEDZM4102_1SHADOWDIR  P1ShadowDIR
#define LEDZM4102_1DIR        P1DIR
#define LEDZM4102_1DIR_PAGE   P1DIR_PAGE
#define LEDZM4102_1           0

#define LED2Port       P3
#define LED2SHADOW     P3Shadow
#define LED2SHADOWDIR  P3ShadowDIR
#define LED2DIR        P3DIR
#define LED2DIR_PAGE   P3DIR_PAGE
#define LED2           7

#define LED3Port       P1
#define LED3SHADOW     P1Shadow
#define LED3SHADOWDIR  P1ShadowDIR
#define LED3DIR        P1DIR
#define LED3DIR_PAGE   P1DIR_PAGE
#define LED3           0

#define LED4Port        P1
#define LED4SHADOW      P1Shadow
#define LED4SHADOWDIR   P1ShadowDIR
#define LED4DIR         P1DIR
#define LED4DIR_PAGE    P1DIR_PAGE
#define LED4            2
#endif

#endif /*ZW040x*/

#endif /* _ZW_EVALDEFS_H_ */
