/****************************  ports.h  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2009
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Header file with definitions of port names of the ATMega128
 *              in ZDP02 (ZDP03) board.
 *
 * Author:      Valeriy Vyshnyak
 *
 * Last Changed By:  $Author: vvi $
 * Revision:         $Revision: 0000 $
 * Last Changed:     $Date: 2009-11-11 $
 *
 ****************************************************************************/

/* definitions generated by preprocessor, copy into defines.h */
#ifndef	_PORTS_H_
#include <avr/io.h>

/* Set I/O pin as input:
 *    pin     - Z-Wave pin name
 *    pullup  - if not zero activate the internal pullup resistor
 */
#define PIN_IN(pin, pullup)  ( (pin##DDR &= ~(1<<pin)), \
    (pullup)?(pin##Port |= (1<<pin)): (pin##Port &= ~(1<<pin)) )

/* Set I/O pin as output:
 *    pin     - Z-Wave pin name
 */
#define PIN_OUT(pin)  (pin##DDR |= (1<<pin))

/* Read pin value:
 *    pin     - Z-Wave pin name
 */
#define PIN_GET(pin)  (pin##Pin & (1<<pin))

/* Set output pin to 1:
 *    pin     - Z-Wave pin name
 */
//#define PIN_ON(pin) (pin##Port |= (1<<pin))
#define PIN_ON(pin)  (pin##Port &= ~(1<<pin))


/* Set output pin to 0:
 *    pin     - Z-Wave pin name
 */
//#define PIN_OFF(pin) (pin##Port &= ~(1<<pin))
#define PIN_OFF(pin) (pin##Port |= (1<<pin))

/* Toggle output pin:
 *    pin     - Z-Wave pin name
 */
#define PIN_TOGGLE(pin) (pin##Port ^=(1<<pin))





/* define pin for enter-self-prog-mode */
#define	PROGPORT	PORTE
#define	PROGPIN	  PINE
#define	PROG_NO	  PE2

#define LEDAPort  PORTC
#define LEDADDR   DDRC
#define LEDAPin   PINC
#define LEDA      PC0

#define LEDBPort  PORTC
#define LEDBDDR   DDRC
#define LEDBPin   PINC
#define LEDB      PC1

#define LEDCPort  PORTC
#define LEDCDDR   DDRC
#define LEDCPin   PINC
#define LEDC      PC2

#define LEDDPort  PORTC
#define LEDDDDR   DDRC
#define LEDDPin   PINC
#define LEDD      PC3

/* VPP control pin. 0 - 3.3V, 1 - 6.5V */
#define PROG_VPPPort  PORTD
#define PROG_VPPDDR   DDRD
#define PROG_VPPPin   PIND
#define PROG_VPP      PD7


#define RESET_NPort  PORTB
#define RESET_NDDR   DDRB
#define RESET_NPin   PINB
#define RESET_N      PB4


#define SS_NPort   PORTB
#define SS_NDDR    DDRB
#define SS_NPin    PINB
#define SS_N       PB5


#define IO9Port   PORTE
#define IO9DDR    DDRE
#define IO9Pin    PINE
#define IO9       PE4


#define _SSPort   PORTB
#define _SSDDR    DDRB
#define _SSPin    PINB
#define _SS       PB0


#define SCKPort   PORTD
#define SCKDDR    DDRD
#define SCKPin    PIND
#define SCK       PD4

#define MOSIPort   PORTD
#define MOSIDDR    DDRD
#define MOSIPin    PIND
#define MOSI       PD1

#define MISOPort   PORTD
#define MISODDR    DDRD
#define MISOPin    PIND
#define MISO       PD5

#define LED1Port   PORTA
#define LED1DDR    DDRA
#define LED1Pin    PINA
#define LED1       PA0

#define LED2Port   PORTA
#define LED2DDR    DDRA
#define LED2Pin    PINA
#define LED2       PA1

#define LED3Port   PORTA
#define LED3DDR    DDRA
#define LED3Pin    PINA
#define LED3       PA2

#define LED4Port   PORTA
#define LED4DDR    DDRA
#define LED4Pin    PINA
#define LED4       PA3

#define LED5Port   PORTA
#define LED5DDR    DDRA
#define LED5Pin    PINA
#define LED5       PA4

#define LED6Port   PORTA
#define LED6DDR    DDRA
#define LED6Pin    PINA
#define LED6       PA5

#define LED7Port   PORTA
#define LED7DDR    DDRA
#define LED7Pin    PINA
#define LED7       PA6

#define LED8Port   PORTA
#define LED8DDR    DDRA
#define LED8Pin    PINA
#define LED8       PA7

#define PUSHB1Port   PORTE
#define PUSHB1DDR    DDRE
#define PUSHB1Pin    PINE
#define PUSHB1       PE2

#define PUSHB2Port   PORTE
#define PUSHB2DDR    DDRE
#define PUSHB2Pin    PINE
#define PUSHB2       PE3

#define PUSHB3Port   PORTE
#define PUSHB3DDR    DDRE
#define PUSHB3Pin    PINE
#define PUSHB3       PE4

#define PUSHB4Port   PORTE
#define PUSHB4DDR    DDRE
#define PUSHB4Pin    PINE
#define PUSHB4       PE5

#define PUSHB5Port   PORTE
#define PUSHB5DDR    DDRE
#define PUSHB5Pin    PINE
#define PUSHB5       PE6

#define PUSHB6Port   PORTE
#define PUSHB6DDR    DDRE
#define PUSHB6Pin    PINE
#define PUSHB6       PE7

#define SCK_CSPort   PORTB
#define SCK_CSDDR    DDRB
#define SCK_CSPin    PINB
#define SCK_CS       PB1

/* indicate that preprocessor result is included */
#define	_PORTS_H_
#endif
