using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Programmer.Properties;

namespace Zensys.ZWave.Programmer.UI
{
    /// <summary>
    /// ProgressForm class.
    /// </summary>
    public partial class ProgressForm : Form
    {

        private System.ComponentModel.BackgroundWorker bkgWorker;

        private Delegate mProgressDelegate;
        /// <summary>
        /// Gets or sets the execute delegate.
        /// </summary>
        /// <value>The progress delegate.</value>
        public Delegate ProgressDelegate
        {
            get { return mProgressDelegate; }
            set { mProgressDelegate = value; }
        }

        /// <summary>
        /// Gets or sets the Progress info text.
        /// </summary>
        /// <value>The progress info.</value>
        public string ProgressInfo
        {
            get { return lblProgressInfo.Text; }
            set { lblProgressInfo.Text = value; }
        }
        private bool mCanCancel;
        /// <summary>
        /// Gets or sets the CanCancel value.
        /// </summary>
        /// <value>The CanCancel value.</value>
        public bool CanCancel
        {
            get { return mCanCancel; }
            set
            {
                mCanCancel = value;
                cmdAbort.Visible = mCanCancel;
            }
        }
        private EventHandler mOnCancel;
        /// <summary>
        /// Occurs when Cancel called.
        /// </summary>
        public event EventHandler OnCancel
        {
            add { mOnCancel += value; }
            remove { mOnCancel -= value; }
        }
        private byte mCommandType;
        /// <summary>
        /// Gets or sets the CommandType value.
        /// </summary>
        /// <value>The CommandType value.</value>
        public byte CommandType
        {
            get { return mCommandType; }
            set { mCommandType = value; }
        }
        private Exception mProgressException;
        /// <summary>
        /// Gets or sets the ProgressException value.
        /// </summary>
        /// <value>The ProgressException value.</value>
        public Exception ProgressException
        {
            get { return mProgressException; }
            set { mProgressException = value; }
        }
        /// <summary>
        /// Initializes a new instance of the <see cref="ProgressForm"/> class.
        /// </summary>
        public ProgressForm()
        {
            System.Diagnostics.Debug.WriteLine("Load");
            InitializeComponent();
            bkgWorker = new BackgroundWorker();
            InitializeBackgoundWorker();
        }

        private void InitializeBackgoundWorker()
        {
            bkgWorker.DoWork += new DoWorkEventHandler(bkgWorker_DoWork);
            bkgWorker.RunWorkerCompleted += new RunWorkerCompletedEventHandler(bkgWorker_RunWorkerCompleted);
            bkgWorker.ProgressChanged += new ProgressChangedEventHandler(bkgWorker_ProgressChanged);
            bkgWorker.WorkerReportsProgress = true;
            bkgWorker.WorkerSupportsCancellation = true;
        }
        void bkgWorker_DoWork(object sender, DoWorkEventArgs e)
        {
            if (ProgressDelegate != null)
            {
                try
                {
                    e.Result = ProgressDelegate.DynamicInvoke(null, null);
                }
                catch (Exception ex)
                {
                    if (ex.InnerException != null)
                        mProgressException = ex.InnerException;
                    else
                        mProgressException = ex;
                }
            }

        }
        void bkgWorker_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
        }
        void bkgWorker_RunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            if (e.Error != null)
            {
                throw e.Error;
            }
            this.Hide();
        }

        private void ProgressForm_Load(object sender, EventArgs e)
        {
            mProgressException = null;
            bkgWorker.RunWorkerAsync();
        }

        internal void SetInfo(string text)
        {
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new EventHandler(delegate
                {
                    lblInfo.Text = text;
                }));
            }
            else
            {
                lblInfo.Text = text;
            }
        }
        internal void SetProgressInfo(string text)
        {
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new EventHandler(delegate
                {
                    lblProgressInfo.Text = text;
                }));
            }
            else
            {
                lblProgressInfo.Text = text;
            }
        }
    }
}