using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Zensys.ZWave.Programmer.Interfaces;

namespace Zensys.ZWave.Programmer.UI
{
    /// <summary>
    /// Main Form class.
    /// </summary>
    public partial class MainForm : Form, IView
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="MainForm"/> class.
        /// </summary>
        public MainForm()
        {
            InitializeComponent();
        }

        #region IView Members

        /// <summary>
        /// Gets or sets the form.
        /// </summary>
        /// <value>The form.</value>
        public Form ViewContainer
        {
            get { return this; }
        }
        private DockStyle mDockStyle = DockStyle.None;
        /// <summary>
        /// Gets or sets the dock style.
        /// </summary>
        /// <value>The dock style.</value>
        public DockStyle DockStyle
        {
            get
            {
                return mDockStyle;
            }
            set
            {
                mDockStyle = value;
            }
        }

        internal System.Windows.Forms.MenuStrip MainMenu
        {
            get { return mainMenu; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ViewToolStripMenuItem
        {
            get { return viewToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ToolsToolStripMenuItem
        {
            get { return toolsToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem SettingsToolStripMenuItem
        {
            get { return settingsToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem HelpToolStripMenuItem
        {
            get { return helpToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem IndexToolStripMenuItem
        {
            get { return indexToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ContentsToolStripMenuItem
        {
            get { return contentsToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem SearchToolStripMenuItem
        {
            get { return searchToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem AboutToolStripMenuItem
        {
            get { return aboutToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.StatusStrip MainStatusStrip
        {
            get { return mainStatusStrip; }
        }
        
        internal WeifenLuo.WinFormsUI.Docking.DockPanel MainDockPanel
        {
            get { return mainDockPanel; }
        }

        internal System.Windows.Forms.ToolStripMenuItem ZW010xToolStripMenuItem
        {
            get { return zW010xToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ZW020xToolStripMenuItem
        {
            get { return zW020xToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ZW030xToolStripMenuItem
        {
            get { return zW030xToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ZW040xToolStripMenuItem
        {
            get { return zW040xToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem ConsoleToolStripMenuItem
        {
            get { return consoleToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem LogToolStripMenuItem
        {
            get { return logToolStripMenuItem; }
        }

        internal System.Windows.Forms.ToolStripMenuItem ExitToolStripMenuItem
        {
            get { return exitToolStripMenuItem; }
        }

        internal System.Windows.Forms.ToolStripStatusLabel SelectedSerialPortStatusLabel
        {
            get { return selectedSerialPortStatusLabel; }
        }
		internal System.Windows.Forms.ToolStripMenuItem DetectTargetToolStripMenuItem
		{
			get { return detectTargetToolStripMenuItem; }
		}
		internal System.Windows.Forms.ToolStripMenuItem UpgradeFirmwareToolStripMenuItem
		{
			get { return upgrageFirmwareToolStripMenuItem; }
		}
		internal System.Windows.Forms.ToolStripMenuItem UploadFirmwareToolStripMenuItem
		{
			get { return uploadFirmwareToolStripMenuItem; }
		}

		internal System.Windows.Forms.ToolStripStatusLabel FirmwareStatusLabel
		{
			get { return firmwareStatusLabel; }
		}

		internal System.Windows.Forms.ToolStripStatusLabel ProgrammerStatusLabel
		{
			get { return programmerStatusLabel; }
		}

		internal System.Windows.Forms.ToolStripMenuItem ResetZWaveModuleToolStripMenuItem
        {
            get { return resetZWaveModuleToolStripMenuItem; }
        }
        
        internal System.Windows.Forms.ToolStripMenuItem CalibrateToolStripMenuItem
        {
            get { return calibrateToolStripMenuItem; }
        }

		#endregion

        private void aPIReferencesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Help.ShowHelp(this, "ZWaveProgrammerAPI.chm");
        }

        private void aboutToolStripMenuItem_Click(object sender, EventArgs e)
        {
            AboutBox about = new AboutBox();
            about.ShowDialog();
        }

    }
}