using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Interfaces;
using Zensys.ZWave.Programmer.UI;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Models;

namespace Zensys.ZWave.Programmer.Dispatchers
{
    /// <summary>
    /// ZW040xFormDispatcher class. Bind/Unbind functions to the ZW040x Form controls.
    /// </summary>
    public class ZW040xFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members

        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ZW040xForm form = (ZW040xForm)view;

            //Form
            form.Load += new EventHandler(actions.ZW040xFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ZW040xFormActions.OnFormClosing);

			form.SramBrowseHexFileButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramBrowseHexFileClick);
			form.FlashBrowseHexFileButton.Click += new EventHandler(actions.ZW040xFormActions.OnFlashBrowseHexFileClick);
			form.EepromBrowseHexFileButton.Click += new EventHandler(actions.ZW040xFormActions.OnEEPROMBrowseHexFileClick);
			form.MtpBrowseHexFileButton.Click += new EventHandler(actions.ZW040xFormActions.OnMtpBrowseHexFileClick);

            form.SramHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW040xFormActions.OnSramHexFileNameChanged);
			form.FlashHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW040xFormActions.OnFlashHexFileNameChanged);
			form.EepromHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW040xFormActions.OnEepromHexFileNameChanged);
			form.MtpHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW040xFormActions.OnMtpHexFileNameChanged);
            

			form.SramReadButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramReadClick);
			form.SramWriteButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramWriteClick);
			form.SramCompareButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramCompareClick);
			form.SramWriteAndRunModeButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramWriteAndRunModeClick);
			form.SramReadOptionsButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramReadOptionsClick);
			form.SramWriteOptionsButton.Click += new EventHandler(actions.ZW040xFormActions.OnSramWriteOptionsClick);
			form.ModeDevelopmentRadioButton.CheckedChanged += new EventHandler(actions.ZW040xFormActions.OnModeDevelopmentCheckedChanged);
            form.ModeDevelopmentRadioButton.Click += new EventHandler(actions.ZW040xFormActions.OnModeDevelopmentClick);
            form.ModeExecOutOfSRAMRadioButton.Click += new EventHandler(actions.ZW040xFormActions.OnModeExecOutOfSRAMClick);

			form.FlashReadButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashReadClick);
			form.FlashWriteButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashWriteClick);
			form.FlashProgramButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashProgramClick);
            form.CalibrateAndProgrammButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashCalibrateAndProgramClick);
			form.FlashCompareButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashCompareClick);
			form.CrcCheckButton.Click += new EventHandler(actions.ZW040xFormActions.OnCrcCheckClick);
			form.FlashReadOptionsButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashReadOptionsClick);
//			form.FlashWriteOptionsButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashWriteOptionsClick);

			form.EepromEraseButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMEraseClick);
			form.EepromReadButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMReadClick);
			form.EepromProgramButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMWriteClick);
			form.EepromCompareButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMCompareClick);

			form.ReadHomeIdButton.Click += new EventHandler(actions.ProgrammerActions.OnReadHomeIdClick);
			form.ChangeHomeIdButton.Click += new EventHandler(actions.ProgrammerActions.OnWriteHomeIdClick);
			form.AutoIncrementHomeIdCheckBox.CheckedChanged += new EventHandler(actions.CommonActions.OnAutoIncrementHomeIdCheckedChanged);

			form.LockBitsReadButton.Click += new EventHandler(actions.ZW040xFormActions.OnLockBitsReadClick);
			form.LockBitsSetButton.Click += new EventHandler(actions.ZW040xFormActions.OnLockBitsSetClick);

			form.MtpAutoEraseCheckBox.Click += new EventHandler(actions.ZW040xFormActions.OnMtpAutoEraseClick);
			form.MtpEraseButton.Click += new EventHandler(actions.ZW040xFormActions.OnMtpEraseClick);
			form.MtpReadButton.Click += new EventHandler(actions.ZW040xFormActions.OnMtpReadClick);
			form.MtpProgramButton.Click += new EventHandler(actions.ZW040xFormActions.OnMTPProgramClick);
			form.MtpCompareButton.Click += new EventHandler(actions.ZW040xFormActions.OnMTPCompareClick);

			documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.ZW040xFormActions.OnDocumentModelStateChanged);

            form.KeyDown += new System.Windows.Forms.KeyEventHandler(actions.ZW040xFormActions.OnKeyDown);
        }

        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ZW040xForm form = (ZW040xForm)view;

            //Form
            form.Load -= new EventHandler(actions.ZW040xFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ZW040xFormActions.OnFormClosing);

			form.SramBrowseHexFileButton.Click -= new EventHandler(actions.ZW040xFormActions.OnSramBrowseHexFileClick);
			form.FlashBrowseHexFileButton.Click -= new EventHandler(actions.ZW040xFormActions.OnFlashBrowseHexFileClick);
			form.EepromBrowseHexFileButton.Click -= new EventHandler(actions.ZW040xFormActions.OnEEPROMBrowseHexFileClick);
			form.MtpBrowseHexFileButton.Click -= new EventHandler(actions.ZW040xFormActions.OnMtpBrowseHexFileClick);

			form.SramHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW040xFormActions.OnSramHexFileNameChanged);
			form.FlashHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW040xFormActions.OnFlashHexFileNameChanged);
			form.EepromHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW040xFormActions.OnEepromHexFileNameChanged);
			form.MtpHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW040xFormActions.OnMtpHexFileNameChanged);

			form.SramReadButton.Click -= new EventHandler(actions.ZW040xFormActions.OnSramReadClick);
			form.SramWriteButton.Click -= new EventHandler(actions.ZW040xFormActions.OnSramWriteClick);
			form.SramCompareButton.Click -= new EventHandler(actions.ZW040xFormActions.OnSramCompareClick);
			form.SramWriteAndRunModeButton.Click -= new EventHandler(actions.ZW040xFormActions.OnSramWriteAndRunModeClick);

			form.FlashReadButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashReadClick);
			form.FlashWriteButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashWriteClick);
			form.FlashProgramButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashProgramClick);
            form.CalibrateAndProgrammButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashCalibrateAndProgramClick);
			form.FlashCompareButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashCompareClick);
			form.CrcCheckButton.Click -= new EventHandler(actions.ZW040xFormActions.OnCrcCheckClick);
			form.FlashReadOptionsButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashReadOptionsClick);
//			form.FlashWriteOptionsButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashWriteOptionsClick);

			form.EepromEraseButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMEraseClick);
			form.EepromReadButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMReadClick);
			form.EepromProgramButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMWriteClick);
			form.EepromCompareButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMCompareClick);

			form.ReadHomeIdButton.Click -= new EventHandler(actions.ProgrammerActions.OnReadHomeIdClick);
			form.ChangeHomeIdButton.Click -= new EventHandler(actions.ProgrammerActions.OnWriteHomeIdClick);
			form.AutoIncrementHomeIdCheckBox.CheckedChanged -= new EventHandler(actions.CommonActions.OnAutoIncrementHomeIdCheckedChanged);

			form.LockBitsReadButton.Click -= new EventHandler(actions.ZW040xFormActions.OnLockBitsReadClick);
			form.LockBitsSetButton.Click -= new EventHandler(actions.ZW040xFormActions.OnLockBitsSetClick);

			form.MtpAutoEraseCheckBox.Click -= new EventHandler(actions.ZW040xFormActions.OnMtpAutoEraseClick);
			form.MtpEraseButton.Click -= new EventHandler(actions.ZW040xFormActions.OnMtpEraseClick);
			form.MtpReadButton.Click -= new EventHandler(actions.ZW040xFormActions.OnMtpReadClick);
			form.MtpProgramButton.Click -= new EventHandler(actions.ZW040xFormActions.OnMTPProgramClick);
			form.MtpCompareButton.Click -= new EventHandler(actions.ZW040xFormActions.OnMTPCompareClick);

			documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.ZW040xFormActions.OnDocumentModelStateChanged);

            form.KeyDown -= new System.Windows.Forms.KeyEventHandler(actions.ZW040xFormActions.OnKeyDown);
		}
        #endregion
    }
}
