using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Interfaces;
using Zensys.ZWave.Programmer.UI;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Models;

namespace Zensys.ZWave.Programmer.Dispatchers
{
    /// <summary>
    /// ZW020xFormDispatcher class. Bind/Unbind functions to the ZW020x Form controls.
    /// </summary>
    public class ZW020xFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ZW020xForm form = (ZW020xForm)view;

            //Form
            form.Load += new EventHandler(actions.ZW020xFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ZW020xFormActions.OnFormClosing);
            form.Shown += new EventHandler(actions.ZW020xFormActions.OnShown);

            form.FlashBrowseHexFileButton.Click += new EventHandler(actions.ZW020xFormActions.OnFlashBrowseHexFileClick);
            form.EepromBrowseHexFileButton.Click += new EventHandler(actions.ZW020xFormActions.OnEEPROMBrowseHexFileClick);

            form.FlashHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW020xFormActions.OnFlashHexFileNameChanged);
            form.EepromHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW020xFormActions.OnEepromHexFileNameChanged);

            form.FlashEraseButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashEraseClick);
            form.FlashReadButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashReadClick);
            form.FlashWriteButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashWriteClick);
            form.FlashProgramButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashProgramClick);
            form.FlashCompareButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashCompareClick);
            form.FlashReadOptionsButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashReadOptionsClick);
            form.FlashWriteOptionsButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashWriteOptionsClick); 

            form.EepromEraseButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMEraseClick);
            form.EepromReadButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMReadClick);
            form.EepromProgramButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMWriteClick);
            form.EepromCompareButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMCompareClick);

            form.ReadHomeIdButton.Click += new EventHandler(actions.ProgrammerActions.OnReadHomeIdClick);
            form.ChangeHomeIdButton.Click += new EventHandler(actions.ProgrammerActions.OnWriteHomeIdClick);

            form.AutoIncrementHomeIdCheckBox.CheckedChanged += new EventHandler(actions.CommonActions.OnAutoIncrementHomeIdCheckedChanged);
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.ZW020xFormActions.OnDocumentModelStateChanged);

			form.LockBitsReadButton.Click += new EventHandler(actions.ZW020xFormActions.OnLockBitsReadClick);
			form.LockBitsSetButton.Click += new EventHandler(actions.ZW020xFormActions.OnLockBitsSetClick);

            form.KeyDown += new System.Windows.Forms.KeyEventHandler(actions.ZW020xFormActions.OnKeyDown);
		}
        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ZW020xForm form = (ZW020xForm)view;

            //Form
            form.Load -= new EventHandler(actions.ZW020xFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ZW020xFormActions.OnFormClosing);
            form.Shown -= new EventHandler(actions.ZW020xFormActions.OnShown);

            form.FlashBrowseHexFileButton.Click -= new EventHandler(actions.ZW020xFormActions.OnFlashBrowseHexFileClick);
            form.EepromBrowseHexFileButton.Click -= new EventHandler(actions.ZW020xFormActions.OnEEPROMBrowseHexFileClick);

            form.FlashHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW020xFormActions.OnFlashHexFileNameChanged);
            form.EepromHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW020xFormActions.OnEepromHexFileNameChanged);

            form.FlashEraseButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashEraseClick);
            form.FlashReadButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashReadClick);
            form.FlashWriteButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashWriteClick);
            form.FlashProgramButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashProgramClick);
            form.FlashCompareButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashCompareClick);
            form.FlashReadOptionsButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashReadOptionsClick);
            form.FlashWriteOptionsButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashWriteOptionsClick); 

            form.EepromEraseButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMEraseClick);
            form.EepromReadButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMReadClick);
            form.EepromProgramButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMWriteClick);
            form.EepromCompareButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMCompareClick);

            form.ReadHomeIdButton.Click -= new EventHandler(actions.ProgrammerActions.OnReadHomeIdClick);
            form.ChangeHomeIdButton.Click -= new EventHandler(actions.ProgrammerActions.OnWriteHomeIdClick);

            form.AutoIncrementHomeIdCheckBox.CheckedChanged -= new EventHandler(actions.CommonActions.OnAutoIncrementHomeIdCheckedChanged);
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.ZW020xFormActions.OnDocumentModelStateChanged);

			form.LockBitsReadButton.Click -= new EventHandler(actions.ZW020xFormActions.OnLockBitsReadClick);
			form.LockBitsSetButton.Click -= new EventHandler(actions.ZW020xFormActions.OnLockBitsSetClick);

            form.KeyDown -= new System.Windows.Forms.KeyEventHandler(actions.ZW020xFormActions.OnKeyDown);
		}

        #endregion
    }
}
