using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Interfaces;
using Zensys.ZWave.Programmer.UI;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Models;

namespace Zensys.ZWave.Programmer.Dispatchers
{
    /// <summary>
    /// ZW010xFormDispatcher class. Bind/Unbind functions to the ZW010x Form controls.
    /// </summary>
	public class ZW010xFormDispatcher : IViewDispatcher
	{
		#region IViewDispatcher Members
        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
		{
			ZW010xForm form = (ZW010xForm)view;

			//Form
			form.Load += new EventHandler(actions.ZW010xFormActions.OnFormLoad);
			form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ZW010xFormActions.OnFormClosing);

            form.FlashBrowseHexFileButton.Click += new EventHandler(actions.ZW010xFormActions.OnFlashBrowseHexFileClick);
            form.EepromBrowseHexFileButton.Click += new EventHandler(actions.ZW010xFormActions.OnEEPROMBrowseHexFileClick);

            form.FlashHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW010xFormActions.OnFlashHexFileNameChanged);
            form.EepromHexFileNameTextBox.TextChanged += new EventHandler(actions.ZW010xFormActions.OnEepromHexFileNameChanged);
            
            form.FlashEraseButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashEraseClick);
			form.FlashReadButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashReadClick);
            form.FlashWriteButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashWriteClick);
            form.FlashProgramButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashProgramClick);
            form.FlashCompareButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashCompareClick);
            form.FlashReadOptionsButton.Click += new EventHandler(actions.ProgrammerActions.OnFlashReadOptionsClick);

			form.EepromEraseButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMEraseClick);
            form.EepromReadButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMReadClick);
            form.EepromProgramButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMWriteClick);
            form.EepromCompareButton.Click += new EventHandler(actions.ProgrammerActions.OnEEPROMCompareClick);

            form.ReadHomeIdButton.Click += new EventHandler(actions.ProgrammerActions.OnReadHomeIdClick);
            form.ChangeHomeIdButton.Click += new EventHandler(actions.ProgrammerActions.OnWriteHomeIdClick);

            form.AutoIncrementHomeIdCheckBox.CheckedChanged += new EventHandler(actions.CommonActions.OnAutoIncrementHomeIdCheckedChanged);
            documentModel.DocumentModelStateChanged += new EventHandler<EventArgs>(actions.ZW010xFormActions.OnDocumentModelStateChanged);

			form.LockBitsReadButton.Click += new EventHandler(actions.ZW010xFormActions.OnLockBitsReadClick);
			form.LockBitsSetButton.Click += new EventHandler(actions.ZW010xFormActions.OnLockBitsSetClick);

            form.KeyDown += new System.Windows.Forms.KeyEventHandler(actions.ZW010xFormActions.OnKeyDown);
		}

        
        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
		{
			ZW010xForm form = (ZW010xForm)view;

			//Form
			form.Load -= new EventHandler(actions.ZW010xFormActions.OnFormLoad);
			form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ZW010xFormActions.OnFormClosing);

            form.FlashBrowseHexFileButton.Click -= new EventHandler(actions.ZW010xFormActions.OnFlashBrowseHexFileClick);
            form.EepromBrowseHexFileButton.Click -= new EventHandler(actions.ZW010xFormActions.OnEEPROMBrowseHexFileClick);

            form.FlashHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW010xFormActions.OnFlashHexFileNameChanged);
            form.EepromHexFileNameTextBox.TextChanged -= new EventHandler(actions.ZW010xFormActions.OnEepromHexFileNameChanged);

            form.FlashEraseButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashEraseClick);
			form.FlashReadButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashReadClick);
            form.FlashWriteButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashWriteClick);
            form.FlashProgramButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashProgramClick);
            form.FlashCompareButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashCompareClick);
            form.FlashReadOptionsButton.Click -= new EventHandler(actions.ProgrammerActions.OnFlashReadOptionsClick); 

			form.EepromEraseButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMEraseClick);
            form.EepromReadButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMReadClick);
            form.EepromProgramButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMWriteClick);
            form.EepromCompareButton.Click -= new EventHandler(actions.ProgrammerActions.OnEEPROMCompareClick);

            form.ReadHomeIdButton.Click -= new EventHandler(actions.ProgrammerActions.OnReadHomeIdClick);
            form.ChangeHomeIdButton.Click -= new EventHandler(actions.ProgrammerActions.OnWriteHomeIdClick);

            form.AutoIncrementHomeIdCheckBox.CheckedChanged -= new EventHandler(actions.CommonActions.OnAutoIncrementHomeIdCheckedChanged);
            documentModel.DocumentModelStateChanged -= new EventHandler<EventArgs>(actions.ZW010xFormActions.OnDocumentModelStateChanged);

			form.LockBitsReadButton.Click -= new EventHandler(actions.ZW010xFormActions.OnLockBitsReadClick);
			form.LockBitsSetButton.Click -= new EventHandler(actions.ZW010xFormActions.OnLockBitsSetClick);

            form.KeyDown -= new System.Windows.Forms.KeyEventHandler(actions.ZW010xFormActions.OnKeyDown);
		}

		#endregion
	}
}
