using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Interfaces;
using Zensys.ZWave.Programmer.UI;
using Zensys.ZWave.Programmer.Classes;
using Zensys.ZWave.Programmer.Models;

namespace Zensys.ZWave.Programmer.Dispatchers
{
    /// <summary>
    /// ConsoleFormDispatcher class. Bind/Unbind functions to the Console Form controls.
    /// </summary>
    public class ConsoleFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        /// <summary>
        /// Binds the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ConsoleForm form = (ConsoleForm)view;

            //Form
            form.Load += new EventHandler(actions.ConsoleFormActions.OnFormLoad);
            form.FormClosing += new System.Windows.Forms.FormClosingEventHandler(actions.ConsoleFormActions.OnFormClosing);

            form.ClearToolStripButton.Click += new EventHandler(actions.ConsoleFormActions.OnClearClick);
            form.SaveToolStripButton.Click += new EventHandler(actions.ConsoleFormActions.OnSaveClick);
            form.CopyToolStripButton.Click += new EventHandler(actions.ConsoleFormActions.OnCopyClick);
        
        }
        /// <summary>
        /// Drops the functions to the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions (functions).</param>
        /// <param name="documentModel">The document model.</param>
        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            ConsoleForm form = (ConsoleForm)view;

            //Form
            form.Load -= new EventHandler(actions.ConsoleFormActions.OnFormLoad);
            form.FormClosing -= new System.Windows.Forms.FormClosingEventHandler(actions.ConsoleFormActions.OnFormClosing);

            form.ClearToolStripButton.Click -= new EventHandler(actions.ConsoleFormActions.OnClearClick);
            form.SaveToolStripButton.Click -= new EventHandler(actions.ConsoleFormActions.OnSaveClick);
            form.CopyToolStripButton.Click -= new EventHandler(actions.ConsoleFormActions.OnCopyClick);
        }

        #endregion
    }
}
