using System;
using System.Collections.Generic;
using System.Text;
using System.Management;

namespace Zensys.ZWave.Programmer.Classes
{
    /// <summary>
    /// SerialPortInfo class.
    /// </summary>
    public class SerialPortInfo
    {
        #region Private Fields
        private ushort? mAvailability = null;
        private bool? mBinary = null;
        private string mCaption = null;
        private uint? mConfigManagerErrorCode = null;
        private bool? mConfigManagerUserConfig = null;
        private string mCreationClassName = null;
        private string mDescription = null;
        private string mDeviceID = null;
        private string mSystemName = null;
        private string mSystemCreationClassName = null;
        private uint? mMaxBaudRate = null;
        private uint? mMaximumInputBufferSize = null;
        private uint? mMaximumOutputBufferSize = null;
        private string mName = null;
        private bool? mOSAutoDiscovered = null;
        private string mPNPDeviceID = null;
        private UInt16[] mPowerManagementCapabilities = null;
        private bool? mPowerManagementSupported = null;
        private string mProviderType = null;
        private bool? mSettableBaudRate = null;
        private bool? mSettableDataBits = null;
        private bool? mSettableFlowControl = null;
        private bool? mSettableParity = null;
        private bool? mSettableParityCheck = null;
        private bool? mSettableRLSD = null;
        private bool? mSettableStopBits = null;
        private string mStatus = null;
        private ushort? mStatusInfo = null;
        private bool? mSupports16BitMode = null;
        private bool? mSupportsDTRDSR = null;
        private bool? mSupportsElapsedTimeouts = null;
        private bool? mSupportsIntTimeouts = null;
        private bool? mSupportsParityCheck = null;
        private bool? mSupportsRLSD = null;
        private bool? mSupportsRTSCTS = null;
        private bool? mSupportsSpecialCharacters = null;
        private bool? mSupportsXOnXOff = null;
        private bool? mSupportsXOnXOffSet = null;
        #endregion
        #region Public Properties
        /// <summary>
        /// Gets the availability.
        /// </summary>
        /// <value>The availability.</value>
        public ushort? Availability
        {
            get { return mAvailability; }
        }
        /// <summary>
        /// Gets the binary.
        /// </summary>
        /// <value>The binary.</value>
        public bool? Binary
        {
            get { return mBinary; }
        }
        /// <summary>
        /// Gets the caption.
        /// </summary>
        /// <value>The caption.</value>
        public string Caption
        {
            get { return mCaption; }
        }
        /// <summary>
        /// Gets the config manager error code.
        /// </summary>
        /// <value>The config manager error code.</value>
        public uint? ConfigManagerErrorCode
        {
            get { return mConfigManagerErrorCode; }
        }
        /// <summary>
        /// Gets the config manager user config.
        /// </summary>
        /// <value>The config manager user config.</value>
        public bool? ConfigManagerUserConfig
        {
            get { return mConfigManagerUserConfig; }
        }
        /// <summary>
        /// Gets the name of the creation class.
        /// </summary>
        /// <value>The name of the creation class.</value>
        public string CreationClassName
        {
            get { return mCreationClassName; }
        }
        /// <summary>
        /// Gets the description.
        /// </summary>
        /// <value>The description.</value>
        public string Description
        {
            get { return mDescription; }
        }
        /// <summary>
        /// Gets the device ID.
        /// </summary>
        /// <value>The device ID.</value>
        public string DeviceID
        {
            get { return mDeviceID; }
        }
        /// <summary>
        /// Gets the max baud rate.
        /// </summary>
        /// <value>The max baud rate.</value>
        public uint? MaxBaudRate
        {
            get { return mMaxBaudRate; }
        }
        /// <summary>
        /// Gets the maximum size of the input buffer.
        /// </summary>
        /// <value>The maximum size of the input buffer.</value>
        public uint? MaximumInputBufferSize
        {
            get { return mMaximumInputBufferSize; }
        }
        /// <summary>
        /// Gets the maximum size of the output buffer.
        /// </summary>
        /// <value>The maximum size of the output buffer.</value>
        public uint? MaximumOutputBufferSize
        {
            get { return mMaximumOutputBufferSize; }
        }
        /// <summary>
        /// Gets the name.
        /// </summary>
        /// <value>The name.</value>
        public string Name
        {
            get { return mName; }
        }
        /// <summary>
        /// Gets the OS auto discovered.
        /// </summary>
        /// <value>The OS auto discovered.</value>
        public bool? OSAutoDiscovered
        {
            get { return mOSAutoDiscovered; }
        }
        /// <summary>
        /// Gets the PNP device ID.
        /// </summary>
        /// <value>The PNP device ID.</value>
        public string PNPDeviceID
        {
            get { return mPNPDeviceID; }
        }
        /// <summary>
        /// Gets the power management capabilities.
        /// </summary>
        /// <value>The power management capabilities.</value>
        public UInt16[] PowerManagementCapabilities
        {
            get { return mPowerManagementCapabilities; }
        }
        /// <summary>
        /// Gets the power management supported.
        /// </summary>
        /// <value>The power management supported.</value>
        public bool? PowerManagementSupported
        {
            get { return mPowerManagementSupported; }
        }
        /// <summary>
        /// Gets the type of the provider.
        /// </summary>
        /// <value>The type of the provider.</value>
        public string ProviderType
        {
            get { return mProviderType; }
        }
        /// <summary>
        /// Gets the settable baud rate.
        /// </summary>
        /// <value>The settable baud rate.</value>
        public bool? SettableBaudRate
        {
            get { return mSettableBaudRate; }
        }
        /// <summary>
        /// Gets the settable data bits.
        /// </summary>
        /// <value>The settable data bits.</value>
        public bool? SettableDataBits
        {
            get { return mSettableDataBits; }
        }
        /// <summary>
        /// Gets the settable flow control.
        /// </summary>
        /// <value>The settable flow control.</value>
        public bool? SettableFlowControl
        {
            get { return mSettableFlowControl; }
        }
        /// <summary>
        /// Gets the settable parity.
        /// </summary>
        /// <value>The settable parity.</value>
        public bool? SettableParity
        {
            get { return mSettableParity; }
        }
        /// <summary>
        /// Gets the settable parity check.
        /// </summary>
        /// <value>The settable parity check.</value>
        public bool? SettableParityCheck
        {
            get { return mSettableParityCheck; }
        }
        /// <summary>
        /// Gets the settable RLSD.
        /// </summary>
        /// <value>The settable RLSD.</value>
        public bool? SettableRLSD
        {
            get { return mSettableRLSD; }
        }
        /// <summary>
        /// Gets the settable stop bits.
        /// </summary>
        /// <value>The settable stop bits.</value>
        public bool? SettableStopBits
        {
            get { return mSettableStopBits; }
        }
        /// <summary>
        /// Gets the status.
        /// </summary>
        /// <value>The status.</value>
        public string Status
        {
            get { return mStatus; }
        }
        /// <summary>
        /// Gets the status info.
        /// </summary>
        /// <value>The status info.</value>
        public ushort? StatusInfo
        {
            get { return mStatusInfo; }
        }
        /// <summary>
        /// Gets the supports 16 bit mode.
        /// </summary>
        /// <value>The supports 16 bit mode.</value>
        public bool? Supports16BitMode
        {
            get { return mSupports16BitMode; }
        }
        /// <summary>
        /// Gets the supports DTRDSR.
        /// </summary>
        /// <value>The supports DTRDSR.</value>
        public bool? SupportsDTRDSR
        {
            get { return mSupportsDTRDSR; }
        }
        /// <summary>
        /// Gets the supports elapsed timeouts.
        /// </summary>
        /// <value>The supports elapsed timeouts.</value>
        public bool? SupportsElapsedTimeouts
        {
            get { return mSupportsElapsedTimeouts; }
        }
        /// <summary>
        /// Gets the supports int timeouts.
        /// </summary>
        /// <value>The supports int timeouts.</value>
        public bool? SupportsIntTimeouts
        {
            get { return mSupportsIntTimeouts; }
        }
        /// <summary>
        /// Gets the supports parity check.
        /// </summary>
        /// <value>The supports parity check.</value>
        public bool? SupportsParityCheck
        {
            get { return mSupportsParityCheck; }
        }
        /// <summary>
        /// Gets the supports RLSD.
        /// </summary>
        /// <value>The supports RLSD.</value>
        public bool? SupportsRLSD
        {
            get { return mSupportsRLSD; }
        }
        /// <summary>
        /// Gets the supports RTSCTS.
        /// </summary>
        /// <value>The supports RTSCTS.</value>
        public bool? SupportsRTSCTS
        {
            get { return mSupportsRTSCTS; }
        }
        /// <summary>
        /// Gets the supports special characters.
        /// </summary>
        /// <value>The supports special characters.</value>
        public bool? SupportsSpecialCharacters
        {
            get { return mSupportsSpecialCharacters; }
        }
        /// <summary>
        /// Gets the supports XOnXOff.
        /// </summary>
        /// <value>The supports XOnXOff.</value>
        public bool? SupportsXOnXOff
        {
            get { return mSupportsXOnXOff; }
        }
        /// <summary>
        /// Gets the supports XOnXOffSet.
        /// </summary>
        /// <value>The supports XOnXOffSet.</value>
        public bool? SupportsXOnXOffSet
        {
            get { return mSupportsXOnXOffSet; }
        }
        /// <summary>
        /// Gets the name of the system creation class.
        /// </summary>
        /// <value>The name of the system creation class.</value>
        public string SystemCreationClassName
        {
            get { return mSystemCreationClassName; }
        }
        /// <summary>
        /// Gets the name of the system.
        /// </summary>
        /// <value>The name of the system.</value>
        public string SystemName
        {
            get { return mSystemName; }
        }
        #endregion
        #region Static Methods
        /// <summary>
        /// Gets the devices.
        /// </summary>
        /// <returns>SerialPortInfo collection.</returns>
        public static List<SerialPortInfo> GetDevices()
        {
            List<SerialPortInfo> result = new List<SerialPortInfo>();
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_SerialPort");
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    SerialPortInfo portInfo = new SerialPortInfo();
                    MapObject2SerialPortInfo(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;
        }
        /// <summary>
        /// Gets the device.
        /// </summary>
        /// <param name="deviceId">The device id.</param>
        /// <returns>SerialPortInfo class.</returns>
        public static SerialPortInfo GetDevice(string deviceId)
        {
            List<SerialPortInfo> list = GetDevices("DeviceID = \"" + deviceId + "\"");
            if (list.Count == 1)
            {
                return list[0];
            }
            return null;
        }
        /// <summary>
        /// Gets the devices.
        /// </summary>
        /// <param name="condition">The condition.</param>
        /// <returns>SerialPortInfo collection.</returns>
        public static List<SerialPortInfo> GetDevices(string condition)
        {
            List<SerialPortInfo> result = new List<SerialPortInfo>();
            try
            {
                ManagementObjectSearcher searcher = new ManagementObjectSearcher("select * from Win32_SerialPort where " + condition);
                foreach (ManagementObject managementObject in searcher.Get())
                {
                    SerialPortInfo portInfo = new SerialPortInfo();
                    MapObject2SerialPortInfo(managementObject, portInfo);
                    result.Add(portInfo);
                }
                searcher.Dispose();
            }
            catch (Exception ex)
            {
                throw ex;
            }
            return result;


        }
        #endregion
        #region Private Methods
        private static void MapObject2SerialPortInfo(ManagementObject managementObject, SerialPortInfo portInfo)
        {
            if (managementObject.Properties["Availability"] != null && managementObject.Properties["Availability"].Value != null)
                portInfo.mAvailability = (ushort?)managementObject.Properties["Availability"].Value;

            if (managementObject.Properties["Binary"] != null && managementObject.Properties["Binary"].Value != null)
                portInfo.mBinary = (bool?)managementObject.Properties["Binary"].Value;

            if (managementObject.Properties["Caption"] != null && managementObject.Properties["Caption"].Value != null)
                portInfo.mCaption = (string)managementObject.Properties["Caption"].Value;

            if (managementObject.Properties["ConfigManagerErrorCode"] != null && managementObject.Properties["ConfigManagerErrorCode"].Value != null)
                portInfo.mConfigManagerErrorCode = (uint?)managementObject.Properties["ConfigManagerErrorCode"].Value;

            if (managementObject.Properties["ConfigManagerUserConfig"] != null && managementObject.Properties["ConfigManagerUserConfig"].Value != null)
                portInfo.mConfigManagerUserConfig = (bool?)managementObject.Properties["ConfigManagerUserConfig"].Value;

            if (managementObject.Properties["CreationClassName"] != null && managementObject.Properties["CreationClassName"].Value != null)
                portInfo.mCreationClassName = (string)managementObject.Properties["CreationClassName"].Value;

            if (managementObject.Properties["Description"] != null && managementObject.Properties["Description"].Value != null)
                portInfo.mDescription = (string)managementObject.Properties["Description"].Value;

            if (managementObject.Properties["DeviceID"] != null && managementObject.Properties["DeviceID"].Value != null)
                portInfo.mDeviceID = (string)managementObject.Properties["DeviceID"].Value;

            if (managementObject.Properties["MaxBaudRate"] != null && managementObject.Properties["MaxBaudRate"].Value != null)
                portInfo.mMaxBaudRate = (uint?)managementObject.Properties["MaxBaudRate"].Value;

            if (managementObject.Properties["MaximumInputBufferSize"] != null && managementObject.Properties["MaximumInputBufferSize"].Value != null)
                portInfo.mMaximumInputBufferSize = (uint?)managementObject.Properties["MaximumInputBufferSize"].Value;

            if (managementObject.Properties["MaximumOutputBufferSize"] != null && managementObject.Properties["MaximumOutputBufferSize"].Value != null)
                portInfo.mMaximumOutputBufferSize = (uint?)managementObject.Properties["MaximumOutputBufferSize"].Value;

            if (managementObject.Properties["Name"] != null && managementObject.Properties["Name"].Value != null)
                portInfo.mName = (string)managementObject.Properties["Name"].Value;

            if (managementObject.Properties["OSAutoDiscovered"] != null && managementObject.Properties["OSAutoDiscovered"].Value != null)
                portInfo.mOSAutoDiscovered = (bool?)managementObject.Properties["OSAutoDiscovered"].Value;

            if (managementObject.Properties["PNPDeviceID"] != null && managementObject.Properties["PNPDeviceID"].Value != null)
                portInfo.mPNPDeviceID = (string)managementObject.Properties["PNPDeviceID"].Value;

            if (managementObject.Properties["PowerManagementCapabilities"] != null && managementObject.Properties["PowerManagementCapabilities"].Value != null)
                portInfo.mPowerManagementCapabilities = (UInt16[])managementObject.Properties["PowerManagementCapabilities"].Value;

            if (managementObject.Properties["PowerManagementSupported"] != null && managementObject.Properties["PowerManagementSupported"].Value != null)
                portInfo.mPowerManagementSupported = (bool?)managementObject.Properties["PowerManagementSupported"].Value;

            if (managementObject.Properties["ProviderType"] != null && managementObject.Properties["ProviderType"].Value != null)
                portInfo.mProviderType = (string)managementObject.Properties["ProviderType"].Value;

            if (managementObject.Properties["SettableBaudRate"] != null && managementObject.Properties["SettableBaudRate"].Value != null)
                portInfo.mSettableBaudRate = (bool?)managementObject.Properties["SettableBaudRate"].Value;

            if (managementObject.Properties["SettableDataBits"] != null && managementObject.Properties["SettableDataBits"].Value != null)
                portInfo.mSettableDataBits = (bool?)managementObject.Properties["SettableDataBits"].Value;

            if (managementObject.Properties["SettableFlowControl"] != null && managementObject.Properties["SettableFlowControl"].Value != null)
                portInfo.mSettableFlowControl = (bool?)managementObject.Properties["SettableFlowControl"].Value;

            if (managementObject.Properties["SettableParity"] != null && managementObject.Properties["SettableParity"].Value != null)
                portInfo.mSettableParity = (bool?)managementObject.Properties["SettableParity"].Value;

            if (managementObject.Properties["SettableParityCheck"] != null && managementObject.Properties["SettableParityCheck"].Value != null)
                portInfo.mSettableParityCheck = (bool?)managementObject.Properties["SettableParityCheck"].Value;

            if (managementObject.Properties["SettableRLSD"] != null && managementObject.Properties["SettableRLSD"].Value != null)
                portInfo.mSettableRLSD = (bool?)managementObject.Properties["SettableRLSD"].Value;

            if (managementObject.Properties["SettableStopBits"] != null && managementObject.Properties["SettableStopBits"].Value != null)
                portInfo.mSettableStopBits = (bool?)managementObject.Properties["SettableStopBits"].Value;

            if (managementObject.Properties["Status"] != null && managementObject.Properties["Status"].Value != null)
                portInfo.mStatus = (string)managementObject.Properties["Status"].Value;

            if (managementObject.Properties["StatusInfo"] != null && managementObject.Properties["StatusInfo"].Value != null)
                portInfo.mStatusInfo = (ushort?)managementObject.Properties["StatusInfo"].Value;

            if (managementObject.Properties["Supports16BitMode"] != null && managementObject.Properties["Supports16BitMode"].Value != null)
                portInfo.mSupports16BitMode = (bool?)managementObject.Properties["Supports16BitMode"].Value;

            if (managementObject.Properties["SupportsDTRDSR"] != null && managementObject.Properties["SupportsDTRDSR"].Value != null)
                portInfo.mSupportsDTRDSR = (bool?)managementObject.Properties["SupportsDTRDSR"].Value;

            if (managementObject.Properties["SupportsElapsedTimeouts"] != null && managementObject.Properties["SupportsElapsedTimeouts"].Value != null)
                portInfo.mSupportsElapsedTimeouts = (bool?)managementObject.Properties["SupportsElapsedTimeouts"].Value;

            if (managementObject.Properties["SupportsIntTimeouts"] != null && managementObject.Properties["SupportsIntTimeouts"].Value != null)
                portInfo.mSupportsIntTimeouts = (bool?)managementObject.Properties["SupportsIntTimeouts"].Value;

            if (managementObject.Properties["SupportsParityCheck"] != null && managementObject.Properties["SupportsParityCheck"].Value != null)
                portInfo.mSupportsParityCheck = (bool?)managementObject.Properties["SupportsParityCheck"].Value;

            if (managementObject.Properties["SupportsRLSD"] != null && managementObject.Properties["SupportsRLSD"].Value != null)
                portInfo.mSupportsRLSD = (bool?)managementObject.Properties["SupportsRLSD"].Value;

            if (managementObject.Properties["SupportsRTSCTS"] != null && managementObject.Properties["SupportsRTSCTS"].Value != null)
                portInfo.mSupportsRTSCTS = (bool?)managementObject.Properties["SupportsRTSCTS"].Value;

            if (managementObject.Properties["SupportsSpecialCharacters"] != null && managementObject.Properties["SupportsSpecialCharacters"].Value != null)
                portInfo.mSupportsSpecialCharacters = (bool?)managementObject.Properties["SupportsSpecialCharacters"].Value;

            if (managementObject.Properties["SupportsXOnXOff"] != null && managementObject.Properties["SupportsXOnXOff"].Value != null)
                portInfo.mSupportsXOnXOff = (bool?)managementObject.Properties["SupportsXOnXOff"].Value;

            if (managementObject.Properties["SupportsXOnXOffSet"] != null && managementObject.Properties["SupportsXOnXOffSet"].Value != null)
                portInfo.mSupportsXOnXOffSet = (bool?)managementObject.Properties["SupportsXOnXOffSet"].Value;

            if (managementObject.Properties["SystemCreationClassName"] != null && managementObject.Properties["SystemCreationClassName"].Value != null)
                portInfo.mSystemCreationClassName = (string)managementObject.Properties["SystemCreationClassName"].Value;

            if (managementObject.Properties["SystemName"] != null && managementObject.Properties["SystemName"].Value != null)
                portInfo.mSystemName = (string)managementObject.Properties["SystemName"].Value;
        }
        #endregion
    }
}
