using System;
using System.Collections.Generic;
using System.Text;

namespace Zensys.ZWave.Programmer.Classes
{
    /// <summary>
    /// NativeMethods class.
    /// </summary>
    public class NativeMethods
    {
        /// <summary>
        /// ATTACH_PARENT_PROCESS constant.
        /// </summary>
        /// <returns></returns>
        public const int ATTACH_PARENT_PROCESS = -1;

        //[System.Runtime.InteropServices.DllImport("kernel32.dll")]
        //static extern bool AllocConsole();

        /// <summary>
        /// Close the console.
        /// </summary>
        /// <returns></returns>
        [System.Runtime.InteropServices.DllImport("kernel32.dll")]
        public static extern bool FreeConsole();

        /// <summary>
        /// Attach to the parent process console.
        /// </summary>
        /// <param name="dwProcessId">The dw process id.</param>
        /// <returns></returns>
        [System.Runtime.InteropServices.DllImport("kernel32.dll")]
        public static extern bool AttachConsole(int dwProcessId);

    }
}
