using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Programmer.Controllers;

namespace Zensys.ZWave.Programmer.Classes
{
    /// <summary>
    /// Base class for actions. Provides methods that extends <see cref="ControllerManager"/> 
    /// </summary>
    public class BaseAction
    {
        private ControllerManager mControllerManager;
        internal ControllerManager ControllerManager
        {
            get { return mControllerManager; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BaseAction"/> class.
        /// </summary>
        /// <param name="controllerManager">The controller manager.</param>
        public BaseAction(ControllerManager controllerManager)
        {
            mControllerManager = controllerManager;
        }
    }
}
