/******************************* led_control.h *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Implements board support functions that controls the LEDs
 *              on the ZDP03A development board.
 *
 * Author:   Erik Friis Harck
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 18624 $
 * Last Changed:     $Date: 2010-09-03 12:57:55 +0200 (fr, 03 sep 2010) $
 *
 ****************************************************************************/
#ifndef _LED_CONTROL_H_
#define _LED_CONTROL_H_


/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/


/****************************************************************************/
/*                              EXTERNAL DEFINED FUNCTIONS/DATA             */
/****************************************************************************/

extern BYTE zm4102_mode_enable;

/*===================================   LedOn   =============================
**    This function turns on the specified LED.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
extern void
LedOn(
  BYTE Led                        /* LED to turn on. */
)
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*===================================   LedOff   ============================
**    This function turns off the specified LED.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
extern void
LedOff(
  BYTE Led                        /* LED to turn on. */
)
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*==================================   LedToggle   ==========================
**    This function toggles the specified LED.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
extern void
LedToggle(
  BYTE Led                        /* LED to toggle. */
)
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*===============================   LedControlInit   ========================
**    This function initializes the LED I/O.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
extern void LedControlInit(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

#endif /*_LED_CONTROL_H_*/
