/******************************* led_control.c *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Implements board support functions that controls the LEDs
 *              on the ZDP03A development board.
 *
 * Author:   Erik Friis Harck
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 18624 $
 * Last Changed:     $Date: 2010-09-03 12:57:55 +0200 (fr, 03 sep 2010) $
 *
 ****************************************************************************/
#ifdef PATCH_ENABLE
/****************************************************************************/
/* Include assembly MACRO definitions for patch insertions.                 */
/*                                                                          */
/* Define $SET (MAKE_PATCHABLE_CODE) for making patchable code destinned    */
/* for OTP or ROM memory.                                                   */
/* Undefine $RESET (MAKE_PATCHABLE_CODE) for making code containing patch   */
/* code destinned for RAM or FLASH memory.                                  */
/****************************************************************************/
#if defined(WORK_PATCH) || defined(STARTER_PATCH)
/* Making code containing patch code destinned for development RAM memory.  */
#pragma asm
$RESET (MAKE_PATCHABLE_CODE)
$INCLUDE (ZW_patch.inc)
#pragma endasm
/* Rename CODE class to CODE_PATCH */
#pragma userclass (code = PATCH)
/* Rename CONST class to CONST_PATCH */
#pragma userclass (const = PATCH)
/* Rename XDATA class to XDATA_PATCH */
#pragma userclass (xdata = PATCH)
#else
/* Making patchable code destinned for OTP or ROM memory.                   */
#pragma asm
$SET (MAKE_PATCHABLE_CODE)
$INCLUDE (ZW_patch.inc)
#pragma endasm
#endif /* elsif defined(WORK_PATCH) || defined(STARTER_PATCH) */
#endif /* PATCH_ENABLE */

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <ZW_patch.h>
#include <ZW_basis_api.h>
#include <ZW_pindefs.h>
#include <ZW_evaldefs.h>
#include <led_control.h>

/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/* zm4102_mode_enable is the entity controlling chip package mode:          */
/* 1. Which pin to use for LED1                                             */
/*                                                                          */
/* This variable/const could be stored anywhere, if you want some kind of   */
/* external control of it.                                                  */
PATCH_VARIABLE BYTE zm4102_mode_enable
#ifndef WORK_PATCH
#ifdef ZM4102
 = TRUE
#else
 = FALSE
#endif
#endif
;

/****************************************************************************/
/*                            PRIVATE FUNCTIONS                             */
/****************************************************************************/


/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/


/*===================================   LedOn   =============================
**    This function turns on the specified LED.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void
PATCH_FUNCTION_NAME(LedOn)(
  BYTE Led                        /* LED to turn on. */
)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(LedOn)
#pragma endasm
#endif
  switch (Led)
  {
    case 1:
      if (zm4102_mode_enable)
      {
        LED_ON(ZM4102_1);
      }
      else
      {
        LED_ON(1);
      }
      break;
    case 2:
      LED_ON(2);
      break;
    case 3:
      if (!zm4102_mode_enable)
      {
        LED_ON(3);
      }
      break;
#ifdef ZW040x
    case 4:
      LED_ON(4);
      break;
#endif
    default:
      break;
  }
}

/*===================================   LedOff   ============================
**    This function turns off the specified LED.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void
PATCH_FUNCTION_NAME(LedOff)(
  BYTE Led                        /* LED to turn on. */
)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(LedOff)
#pragma endasm
#endif
  switch (Led)
  {
    case 1:
      if (zm4102_mode_enable)
      {
        LED_OFF(ZM4102_1);
      }
      else
      {
        LED_OFF(1);
      }
      break;
    case 2:
      LED_OFF(2);
      break;
    case 3:
      if (!zm4102_mode_enable)
      {
        LED_OFF(3);
      }
      break;
#ifdef ZW040x
    case 4:
      LED_OFF(4);
      break;
#endif
    default:
      break;
  }
}

/*==================================   LedToggle   ==========================
**    This function toggles the specified LED.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void
PATCH_FUNCTION_NAME(LedToggle)(
  BYTE Led                        /* LED to toggle. */
)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(LedToggle)
#pragma endasm
#endif
  switch (Led)
  {
    case 1:
      if (zm4102_mode_enable)
      {
        LED_TOGGLE(ZM4102_1);
      }
      else
      {
        LED_TOGGLE(1);
      }
      break;
    case 2:
      LED_TOGGLE(2);
      break;
    case 3:
      if (!zm4102_mode_enable)
      {
        LED_TOGGLE(3);
      }
      break;
#ifdef ZW040x
    case 4:
      LED_TOGGLE(4);
      break;
#endif
    default:
      break;
  }
}

/*===============================   LedControlInit   ========================
**    This function initializes the LED I/O.
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void
PATCH_FUNCTION_NAME(LedControlInit)(void)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(LedControlInit)
#pragma endasm
#endif

  /* Setup specifics for current dim module */
  if (zm4102_mode_enable)
  {
    PIN_OUT(LEDZM4102_1);
  }
  else
  {
    PIN_OUT(LED1);
  }
  PIN_OUT(LED2);
  if (!zm4102_mode_enable)
  {
    PIN_OUT(LED3);
  }
#ifdef ZW040x
  PIN_OUT(LED4);
#endif
}
