/******************************* ZW_TransportZIP.h *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2009
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Implements functions for transporting frames over the
 *               Z/IP
 *
 * Author:   Valeriy Vyshnyak
 *
 * Last Changed By:  $Author: vvi $
 * Revision:         $Revision: 13417 $
 * Last Changed:     $Date: 2009-03-10 16:17:52 +0200 (Вв, 10 Бер 2009) $
 *
 ****************************************************************************/
#ifndef _TRANSPORT_ZIP_H_
#define _TRANSPORT_ZIP_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/


/****************************************************************************/
/*                              IMPORTED DATA                               */
/****************************************************************************/
extern ZW_APPLICATION_TX_BUFFER txBuf;


/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/
typedef void (CODE *VOID_CALLBACKFUNC_BYTE)(BYTE txStatus);			/* callback function, which called by the transport layer when data is transmitted */

typedef void (CODE *TRANSPORT_STATUS_CALLBACK)(BYTE transportStatus);	/* callback function, which called by transport to inform application layer of its status */
/* Values of transportStatus argument of Transport status callback function: */
#define TRANSPORT_WORK_START		0x01	/* Transport layer begin the longly work operation. This status can be used to stop the power down timeout timer in battery operated devices */
#define TRANSPORT_WORK_END			0x02	/* Transport layer successfully end the longly work operation. This status can be used to start the power down timeout timer in battery operated devices */
#define TRANSPORT_WORK_ERROR		0x03	/* Transport layer abort the longly work operation. This status can be used to start the power down timeout timer in battery operated devices */

#define TRANSPORT_EEPROM_SETTINGS_SIZE  0

#define TRANSPORT_ZIP_SOURCE_PORT_MIN   0xF0B1
#define TRANSPORT_ZIP_SOURCE_PORT_MAX   0xF0BF






/* Network structures, types and defines: */
#define IPV4_VERSION                4
#define IPV6_VERSION                6

#define IPV4_HEADER_SIZE_MIN        20
#define IPV4_HEADER_SIZE_MAX        60
#define IPV4_HEADER_WORD_SIZE       4

#define IPV6_HEADER_SIZE_MIN        40

#define IPV4_ADDRESS_SIZE			4
#define IPV6_ADDRESS_SIZE			16

#define IPV4_SUBNET_ADDRESS_SIZE	3
#define IPV6_SUBNET_ADDRESS_SIZE	15

#define HOP_LIMIT					0x80


/* C++ needs to know that types and declarations are C, not C++.  */
#ifdef  __cplusplus
# define __BEGIN_DECLS  extern "C" {
# define __END_DECLS  }
#else
# define __BEGIN_DECLS
# define __END_DECLS
#endif

/* Definitions for byte order, according to significance of bytes,
   from low addresses to high addresses.  The value is what you get by
   putting '4' in the most significant byte, '3' in the second most
   significant byte, '2' in the second least significant byte, and '1'
   in the least significant byte, and then writing down one digit for
   each byte, starting with the byte at the lowest address at the left,
   and proceeding to the byte with the highest address at the right.  */

#define __LITTLE_ENDIAN 1234
#define __BIG_ENDIAN  4321
#define __PDP_ENDIAN  3412

#define __BYTE_ORDER __LITTLE_ENDIAN

/* Old compatibility names for C types.  */
typedef unsigned long int ulong;
typedef unsigned short int ushort;
typedef unsigned int uint;
typedef unsigned char uchar;

typedef unsigned long int u_long;
typedef unsigned short int u_short;
typedef unsigned int u_int;
typedef unsigned char u_char;

/* These size-specific names are used by some of the inet code.  */

/* But these were defined by ISO C without the first `_'.  */
typedef unsigned char u_int8_t;
typedef unsigned int u_int16_t;
typedef unsigned long u_int32_t;

/*
 * __xx is ok: it doesn't pollute the POSIX namespace. Use these in the
 * header files exported to user space
 */
#define __signed__ signed

typedef __signed__ char __s8;
typedef unsigned char __u8;

typedef __signed__ short __s16;
typedef unsigned short __u16;

typedef __signed__ long __s32;
typedef unsigned long __u32;


/* Exact integral types.  */

/* Signed.  */

/* There is some amount of overlap with <sys/types.h> as known by inet code */
typedef signed char   int8_t;
typedef short int   int16_t;
typedef long      int32_t;

/* Unsigned.  */
typedef unsigned char   uint8_t;
typedef unsigned short int  uint16_t;
typedef unsigned long   uint32_t;


/* Small types.  */

/* Signed.  */
typedef signed char   int_least8_t;
typedef short int   int_least16_t;
typedef long      int_least32_t;

/* Unsigned.  */
typedef unsigned char   uint_least8_t;
typedef unsigned short int  uint_least16_t;
typedef unsigned long   uint_least32_t;


/* Fast types.  */

/* Signed.  */
typedef signed char   int_fast8_t;
typedef int           int_fast16_t;
typedef long          int_fast32_t;

/* Unsigned.  */
typedef unsigned char   uint_fast8_t;
typedef unsigned int    uint_fast16_t;
typedef unsigned long   uint_fast32_t;












/* Swap bytes in 16 bit value.  */
# define __bswap_16(x) \
    (__extension__                    \
     ({ unsigned short int __bsx = (x);               \
        ((((__bsx) >> 8) & 0xff) | (((__bsx) & 0xff) << 8)); }))

/* Swap bytes in 32 bit value.  */
# define __bswap_32(x) \
    (__extension__                    \
     ({ unsigned int __bsx = (x);               \
        ((((__bsx) & 0xff000000) >> 24) | (((__bsx) & 0x00ff0000) >>  8) |    \
   (((__bsx) & 0x0000ff00) <<  8) | (((__bsx) & 0x000000ff) << 24)); }))

/* Swap bytes in 64 bit value.  */
# define __bswap_constant_64(x) \
     ((((x) & 0xff00000000000000ull) >> 56)             \
      | (((x) & 0x00ff000000000000ull) >> 40)             \
      | (((x) & 0x0000ff0000000000ull) >> 24)             \
      | (((x) & 0x000000ff00000000ull) >> 8)              \
      | (((x) & 0x00000000ff000000ull) << 8)              \
      | (((x) & 0x0000000000ff0000ull) << 24)             \
      | (((x) & 0x000000000000ff00ull) << 40)             \
      | (((x) & 0x00000000000000ffull) << 56))

# define __bswap_64(x) \
     (__extension__                   \
      ({ union { __extension__ unsigned long long int __ll;         \
     unsigned int __l[2]; } __w, __r;           \
         if (__builtin_constant_p (x))                \
     __r.__ll = __bswap_constant_64 (x);              \
   else                     \
     {                      \
       __w.__ll = (x);                  \
       __r.__l[0] = __bswap_32 (__w.__l[1]);            \
       __r.__l[1] = __bswap_32 (__w.__l[0]);            \
     }                      \
   __r.__ll; }))

/* The following definitions must all be macros since otherwise some
   of the possible optimizations are not possible.  */

/* Return a value with all bytes in the 16 bit argument swapped.  */
#define bswap_16(x) __bswap_16 (x)

/* Return a value with all bytes in the 32 bit argument swapped.  */
#define bswap_32(x) __bswap_32 (x)

/* Return a value with all bytes in the 64 bit argument swapped.  */
# define bswap_64(x) __bswap_64 (x)





typedef struct timestamp_tag
  {
    u_int8_t len;
    u_int8_t ptr;
#if __BYTE_ORDER == __LITTLE_ENDIAN
    unsigned int flags:4;
    unsigned int overflow:4;
#elif __BYTE_ORDER == __BIG_ENDIAN
    unsigned int overflow:4;
    unsigned int flags:4;
#else
# error "Please fix <bits/endian.h>"
#endif
    u_int32_t dat[9];
  } timestamp;

typedef struct iphdr_tag
  {
#if __BYTE_ORDER == __LITTLE_ENDIAN
    unsigned char ihl:4;
    unsigned char version:4;
#elif __BYTE_ORDER == __BIG_ENDIAN
    unsigned char version:4;
    unsigned char ihl:4;
#else
# error "Please fix <bits/endian.h>"
#endif
    u_int8_t tos;
    u_int16_t tot_len;
    u_int16_t id;
    u_int16_t frag_off;
    u_int8_t ttl;
    u_int8_t protocol;
    u_int16_t check;
    u_int32_t saddr;
    u_int32_t daddr;
    /*The options start here. */
  } iphdr;









typedef struct udphdr_tag {
  __u16 source;
  __u16 dest;
  __u16 len;
  __u16 check;
} udphdr;

typedef struct icmphdr_tag
{
  u_int8_t type;    /* message type */
  u_int8_t cod;   /* type sub-code */
  u_int16_t checksum;
  union
  {
    struct
    {
      u_int16_t id;
      u_int16_t sequence;
    } echo;     /* echo datagram */
    u_int32_t gateway;  /* gateway address */
    struct
    {
      u_int16_t __unused;
      u_int16_t mtu;
    } frag;     /* path mtu discovery */
  } un;
} icmphdr;

#define ICMP_ECHOREPLY    0 /* Echo Reply     */
#define ICMP_DEST_UNREACH 3 /* Destination Unreachable  */
#define ICMP_SOURCE_QUENCH  4 /* Source Quench    */
#define ICMP_REDIRECT   5 /* Redirect (change route)  */
#define ICMP_ECHO   8 /* Echo Request     */
#define ICMP_TIME_EXCEEDED  11  /* Time Exceeded    */
#define ICMP_PARAMETERPROB  12  /* Parameter Problem    */
#define ICMP_TIMESTAMP    13  /* Timestamp Request    */
#define ICMP_TIMESTAMPREPLY 14  /* Timestamp Reply    */
#define ICMP_INFO_REQUEST 15  /* Information Request    */
#define ICMP_INFO_REPLY   16  /* Information Reply    */
#define ICMP_ADDRESS    17  /* Address Mask Request   */
#define ICMP_ADDRESSREPLY 18  /* Address Mask Reply   */
#define NR_ICMP_TYPES   18

/* Codes for UNREACH. */
#define ICMP_NET_UNREACH  0 /* Network Unreachable    */
#define ICMP_HOST_UNREACH 1 /* Host Unreachable   */
#define ICMP_PROT_UNREACH 2 /* Protocol Unreachable   */
#define ICMP_PORT_UNREACH 3 /* Port Unreachable   */
#define ICMP_FRAG_NEEDED  4 /* Fragmentation Needed/DF set  */
#define ICMP_SR_FAILED    5 /* Source Route failed    */
#define ICMP_NET_UNKNOWN  6
#define ICMP_HOST_UNKNOWN 7
#define ICMP_HOST_ISOLATED  8
#define ICMP_NET_ANO    9
#define ICMP_HOST_ANO   10
#define ICMP_NET_UNR_TOS  11
#define ICMP_HOST_UNR_TOS 12
#define ICMP_PKT_FILTERED 13  /* Packet filtered */
#define ICMP_PREC_VIOLATION 14  /* Precedence violation */
#define ICMP_PREC_CUTOFF  15  /* Precedence cut off */
#define NR_ICMP_UNREACH   15  /* instead of hardcoding immediate value */

/* Codes for REDIRECT. */
#define ICMP_REDIR_NET    0 /* Redirect Net     */
#define ICMP_REDIR_HOST   1 /* Redirect Host    */
#define ICMP_REDIR_NETTOS 2 /* Redirect Net for TOS   */
#define ICMP_REDIR_HOSTTOS  3 /* Redirect Host for TOS  */

/* Codes for TIME_EXCEEDED. */
#define ICMP_EXC_TTL    0 /* TTL count exceeded   */
#define ICMP_EXC_FRAGTIME 1 /* Fragment Reass time exceeded */

#define ICMP6_ECHO_REQUEST          128
#define ICMP6_ECHO_REPLY            129
#define ICMP6_MEMBERSHIP_QUERY      130
#define ICMP6_MEMBERSHIP_REPORT     131
#define ICMP6_MEMBERSHIP_REDUCTION  132



/* Standard well-defined IP protocols.  */
enum
  {
    IPPROTO_IP = 0,    /* Dummy protocol for TCP.  */
#define IPPROTO_IP    IPPROTO_IP
    IPPROTO_HOPOPTS = 0,   /* IPv6 Hop-by-Hop options.  */
#define IPPROTO_HOPOPTS   IPPROTO_HOPOPTS
    IPPROTO_ICMP = 1,    /* Internet Control Message Protocol.  */
#define IPPROTO_ICMP    IPPROTO_ICMP
    IPPROTO_IGMP = 2,    /* Internet Group Management Protocol. */
#define IPPROTO_IGMP    IPPROTO_IGMP
    IPPROTO_IPIP = 4,    /* IPIP tunnels (older KA9Q tunnels use 94).  */
#define IPPROTO_IPIP    IPPROTO_IPIP
    IPPROTO_TCP = 6,     /* Transmission Control Protocol.  */
#define IPPROTO_TCP   IPPROTO_TCP
    IPPROTO_EGP = 8,     /* Exterior Gateway Protocol.  */
#define IPPROTO_EGP   IPPROTO_EGP
    IPPROTO_PUP = 12,    /* PUP protocol.  */
#define IPPROTO_PUP   IPPROTO_PUP
    IPPROTO_UDP = 17,    /* User Datagram Protocol.  */
#define IPPROTO_UDP   IPPROTO_UDP
    IPPROTO_IDP = 22,    /* XNS IDP protocol.  */
#define IPPROTO_IDP   IPPROTO_IDP
    IPPROTO_TP = 29,     /* SO Transport Protocol Class 4.  */
#define IPPROTO_TP    IPPROTO_TP
    IPPROTO_IPV6 = 41,     /* IPv6 header.  */
#define IPPROTO_IPV6    IPPROTO_IPV6
    IPPROTO_ROUTING = 43,  /* IPv6 routing header.  */
#define IPPROTO_ROUTING   IPPROTO_ROUTING
    IPPROTO_FRAGMENT = 44, /* IPv6 fragmentation header.  */
#define IPPROTO_FRAGMENT  IPPROTO_FRAGMENT
    IPPROTO_RSVP = 46,     /* Reservation Protocol.  */
#define IPPROTO_RSVP    IPPROTO_RSVP
    IPPROTO_GRE = 47,    /* General Routing Encapsulation.  */
#define IPPROTO_GRE   IPPROTO_GRE
    IPPROTO_ESP = 50,      /* encapsulating security payload.  */
#define IPPROTO_ESP   IPPROTO_ESP
    IPPROTO_AH = 51,       /* authentication header.  */
#define IPPROTO_AH    IPPROTO_AH
    IPPROTO_ICMPV6 = 58,   /* ICMPv6.  */
#define IPPROTO_ICMPV6    IPPROTO_ICMPV6
    IPPROTO_NONE = 59,     /* IPv6 no next header.  */
#define IPPROTO_NONE    IPPROTO_NONE
    IPPROTO_DSTOPTS = 60,  /* IPv6 destination options.  */
#define IPPROTO_DSTOPTS   IPPROTO_DSTOPTS
    IPPROTO_MTP = 92,    /* Multicast Transport Protocol.  */
#define IPPROTO_MTP   IPPROTO_MTP
    IPPROTO_ENCAP = 98,    /* Encapsulation Header.  */
#define IPPROTO_ENCAP   IPPROTO_ENCAP
    IPPROTO_PIM = 103,     /* Protocol Independent Multicast.  */
#define IPPROTO_PIM   IPPROTO_PIM
    IPPROTO_COMP = 108,    /* Compression Header Protocol.  */
#define IPPROTO_COMP    IPPROTO_COMP
    IPPROTO_SCTP = 132,    /* Stream Control Transmission Protocol.  */
#define IPPROTO_SCTP    IPPROTO_SCTP
    IPPROTO_RAW = 255,     /* Raw IP packets.  */
#define IPPROTO_RAW   IPPROTO_RAW
    IPPROTO_MAX
  };


/* Type to represent a port.  */
typedef uint16_t in_port_t;

/* Standard well-known ports.  */
enum
  {
    IPPORT_ECHO = 7,    /* Echo service.  */
    IPPORT_DISCARD = 9,   /* Discard transmissions service.  */
    IPPORT_SYSTAT = 11,   /* System status service.  */
    IPPORT_DAYTIME = 13,  /* Time of day service.  */
    IPPORT_NETSTAT = 15,  /* Network status service.  */
    IPPORT_FTP = 21,    /* File Transfer Protocol.  */
    IPPORT_TELNET = 23,   /* Telnet protocol.  */
    IPPORT_SMTP = 25,   /* Simple Mail Transfer Protocol.  */
    IPPORT_TIMESERVER = 37, /* Timeserver service.  */
    IPPORT_NAMESERVER = 42, /* Domain Name Service.  */
    IPPORT_WHOIS = 43,    /* Internet Whois service.  */
    IPPORT_MTP = 57,

    IPPORT_TFTP = 69,   /* Trivial File Transfer Protocol.  */
    IPPORT_RJE = 77,
    IPPORT_FINGER = 79,   /* Finger service.  */
    IPPORT_TTYLINK = 87,
    IPPORT_SUPDUP = 95,   /* SUPDUP protocol.  */


    IPPORT_EXECSERVER = 512,  /* execd service.  */
    IPPORT_LOGINSERVER = 513, /* rlogind service.  */
    IPPORT_CMDSERVER = 514,
    IPPORT_EFSSERVER = 520,

    /* UDP ports.  */
    IPPORT_BIFFUDP = 512,
    IPPORT_WHOSERVER = 513,
    IPPORT_ROUTESERVER = 520,

    /* Ports less than this value are reserved for privileged processes.  */
    IPPORT_RESERVED = 1024,

    IPPORT_ZWAVE = 4123,     /* Z-Wave Protocol  */

    /* Ports greater this value are reserved for (non-privileged) servers.  */
    IPPORT_USERRESERVED = 5000
  };


/* Internet address.  */
typedef uint32_t in_addr_t;

typedef struct in_addr_tag
  {
    in_addr_t s_addr;
  } in_addr;


/* IPv4 address */
typedef struct in4_addr_tag
{
  union
  {
	uint8_t u4_addr8[4];
	in_addr in_addr_s;
  } u_in4_addr;
#define s4_addr 	in_addr_s.s_addr
} in4_addr;


/* Definitions of the bits in an Internet address integer.

   On subnets, host and network parts are found according to
   the subnet mask, not these masks.  */

#define IN_CLASSA(a)    ((((in_addr_t)(a)) & 0x80000000) == 0)
#define IN_CLASSA_NET   0xff000000
#define IN_CLASSA_NSHIFT  24
#define IN_CLASSA_HOST    (0xffffffff & ~IN_CLASSA_NET)
#define IN_CLASSA_MAX   128

#define IN_CLASSB(a)    ((((in_addr_t)(a)) & 0xc0000000) == 0x80000000)
#define IN_CLASSB_NET   0xffff0000
#define IN_CLASSB_NSHIFT  16
#define IN_CLASSB_HOST    (0xffffffff & ~IN_CLASSB_NET)
#define IN_CLASSB_MAX   65536

#define IN_CLASSC(a)    ((((in_addr_t)(a)) & 0xe0000000) == 0xc0000000)
#define IN_CLASSC_NET   0xffffff00
#define IN_CLASSC_NSHIFT  8
#define IN_CLASSC_HOST    (0xffffffff & ~IN_CLASSC_NET)

#define IN_CLASSD(a)    ((((in_addr_t)(a)) & 0xf0000000) == 0xe0000000)
#define IN_MULTICAST(a)   IN_CLASSD(a)

#define IN_EXPERIMENTAL(a)  ((((in_addr_t)(a)) & 0xe0000000) == 0xe0000000)
#define IN_BADCLASS(a)    ((((in_addr_t)(a)) & 0xf0000000) == 0xf0000000)

/* Address to accept any incoming messages.  */
#define INADDR_ANY    ((in_addr_t) 0x00000000)
/* Address to send to all hosts.  */
#define INADDR_BROADCAST  ((in_addr_t) 0xffffffff)
/* Address indicating an error return.  */
#define INADDR_NONE   ((in_addr_t) 0xffffffff)

/* Network number for local host loopback.  */
#define IN_LOOPBACKNET    127
/* Address to loopback in software to local host.  */
#ifndef INADDR_LOOPBACK
# define INADDR_LOOPBACK  ((in_addr_t) 0x7f000001) /* Inet 127.0.0.1.  */
#endif

/* Defines for Multicast INADDR.  */
#define INADDR_UNSPEC_GROUP ((in_addr_t) 0xe0000000) /* 224.0.0.0 */
#define INADDR_ALLHOSTS_GROUP ((in_addr_t) 0xe0000001) /* 224.0.0.1 */
#define INADDR_ALLRTRS_GROUP    ((in_addr_t) 0xe0000002) /* 224.0.0.2 */
#define INADDR_MAX_LOCAL_GROUP  ((in_addr_t) 0xe00000ff) /* 224.0.0.255 */

/* IPv6 address */
typedef struct in6_addr_tag
  {
    union
      {
  uint8_t u6_addr8[16];
  uint16_t u6_addr16[8];
  uint32_t u6_addr32[4];
      } in6_u;
#define s6_addr     in6_u.u6_addr8
#define s6_addr16   in6_u.u6_addr16
#define s6_addr32   in6_u.u6_addr32
  } in6_addr;




typedef struct iphdr6_tag
  {
    union
      {
	struct ip6_hdrctl
	  {
	    uint32_t ip6_un1_flow;   /* 4 bits version, 8 bits TC,
					20 bits flow-ID */
	    uint16_t ip6_un1_plen;   /* payload length */
	    uint8_t  ip6_un1_nxt;    /* next header */
	    uint8_t  ip6_un1_hlim;   /* hop limit */
	  } ip6_un1;
	uint8_t ip6_un2_vfc;       /* 4 bits version, top 4 bits tclass */
      } ip6_ctlun;
    /*struct*/ in6_addr ip6_src;      /* source address */
    /*struct*/ in6_addr ip6_dst;      /* destination address */
  }iphdr6;



typedef struct icmphdr6_tag
  {
    uint8_t     icmp6_type;   /* type field */
    uint8_t     icmp6_code;   /* code field */
    uint16_t    icmp6_cksum;  /* checksum field */
    union
      {
	uint32_t  icmp6_un_data32[1]; /* type-specific field */
	uint16_t  icmp6_un_data16[2]; /* type-specific field */
	uint8_t   icmp6_un_data8[4];  /* type-specific field */
      } icmp6_dataun;
  }icmphdr6;



#define IN6ADDR_ANY_INIT { { { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 } } }
#define IN6ADDR_LOOPBACK_INIT { { { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1 } } }

#define INET_ADDRSTRLEN 16
#define INET6_ADDRSTRLEN 46


/* We can optimize calls to the conversion functions.  Either nothing has
   to be done or we are using directly the byte-swapping functions which
   often can be inlined.  */
# if __BYTE_ORDER == __BIG_ENDIAN
/* The host byte order is the same as network byte order,
   so these functions are all just identity.  */
# define ntohl(x) (x)
# define ntohs(x) (x)
# define htonl(x) (x)
# define htons(x) (x)
# else
#  if __BYTE_ORDER == __LITTLE_ENDIAN
#   define ntohl(x) __bswap_32 (x)
#   define ntohs(x) __bswap_16 (x)
#   define htonl(x) __bswap_32 (x)
#   define htons(x) __bswap_16 (x)
#  endif
# endif

#define IN6_IS_ADDR_UNSPECIFIED(a) \
  (((__const uint32_t *) (a))[0] == 0             \
   && ((__const uint32_t *) (a))[1] == 0              \
   && ((__const uint32_t *) (a))[2] == 0              \
   && ((__const uint32_t *) (a))[3] == 0)

#define IN6_IS_ADDR_LOOPBACK(a) \
  (((__const uint32_t *) (a))[0] == 0             \
   && ((__const uint32_t *) (a))[1] == 0              \
   && ((__const uint32_t *) (a))[2] == 0              \
   && ((__const uint32_t *) (a))[3] == htonl (1))

#define IN6_IS_ADDR_MULTICAST(a) (((__const uint8_t *) (a))[0] == 0xff)

#define IN6_IS_ADDR_LINKLOCAL(a) \
  ((((__const uint32_t *) (a))[0] & htonl (0xffc00000))         \
   == htonl (0xfe800000))

#define IN6_IS_ADDR_SITELOCAL(a) \
  ((((__const uint32_t *) (a))[0] & htonl (0xffc00000))         \
   == htonl (0xfec00000))

#define IN6_IS_ADDR_V4MAPPED(a) \
  ((((__const uint32_t *) (a))[0] == 0)             \
   && (((__const uint32_t *) (a))[1] == 0)            \
   && (((__const uint32_t *) (a))[2] == htonl (0xffff)))

#define IN6_IS_ADDR_V4COMPAT(a) \
  ((((__const uint32_t *) (a))[0] == 0)             \
   && (((__const uint32_t *) (a))[1] == 0)            \
   && (((__const uint32_t *) (a))[2] == 0)            \
   && (ntohl (((__const uint32_t *) (a))[3]) > 1))

#define IN6_ARE_ADDR_EQUAL(a,b) \
  ((((__const uint32_t *) (a))[0] == ((__const uint32_t *) (b))[0])     \
   && (((__const uint32_t *) (a))[1] == ((__const uint32_t *) (b))[1])  \
   && (((__const uint32_t *) (a))[2] == ((__const uint32_t *) (b))[2])  \
   && (((__const uint32_t *) (a))[3] == ((__const uint32_t *) (b))[3]))

#define IN6_IS_ADDR_MC_NODELOCAL(a) \
  (IN6_IS_ADDR_MULTICAST(a)               \
   && ((((__const uint8_t *) (a))[1] & 0xf) == 0x1))

#define IN6_IS_ADDR_MC_LINKLOCAL(a) \
  (IN6_IS_ADDR_MULTICAST(a)               \
   && ((((__const uint8_t *) (a))[1] & 0xf) == 0x2))

#define IN6_IS_ADDR_MC_SITELOCAL(a) \
  (IN6_IS_ADDR_MULTICAST(a)               \
   && ((((__const uint8_t *) (a))[1] & 0xf) == 0x5))

#define IN6_IS_ADDR_MC_ORGLOCAL(a) \
  (IN6_IS_ADDR_MULTICAST(a)               \
   && ((((__const uint8_t *) (a))[1] & 0xf) == 0x8))

#define IN6_IS_ADDR_MC_GLOBAL(a) \
  (IN6_IS_ADDR_MULTICAST(a)               \
   && ((((__const uint8_t *) (a))[1] & 0xf) == 0xe))






typedef u_int32_t tcp_seq;
/*
 * TCP header.
 * Per RFC 793, September, 1981.
 */
struct tcphdr {
  u_short th_sport;   /* source port */
  u_short th_dport;   /* destination port */
  tcp_seq th_seq;     /* sequence number */
  tcp_seq th_ack;     /* acknowledgement number */
#if __BYTE_ORDER == __LITTLE_ENDIAN
  u_char  th_x2:4,    /* (unused) */
    th_off:4;   /* data offset */
#endif
#if __BYTE_ORDER == __BIG_ENDIAN
  u_char  th_off:4,   /* data offset */
    th_x2:4;    /* (unused) */
#endif
  u_char  th_flags;
#define TH_FIN  0x01
#define TH_SYN  0x02
#define TH_RST  0x04
#define TH_PUSH 0x08
#define TH_ACK  0x10
#define TH_URG  0x20
  u_short th_win;     /* window */
  u_short th_sum;     /* checksum */
  u_short th_urp;     /* urgent pointer */
};

#define TCPOPT_EOL  0
#define TCPOPT_NOP  1
#define TCPOPT_MAXSEG 2

/*
 * Default maximum segment size for TCP.
 * With an IP MSS of 576, this is 536,
 * but 512 is probably more convenient.
 */
#ifdef  lint
#define TCP_MSS 536
#else
#define TCP_MSS MIN(512, IP_MSS - sizeof (struct tcpiphdr))
#endif





#define IP_ADDR_TYPE_IPV4     0x00
#define IP_ADDR_TYPE_IPV6     0x01

typedef struct IP_ADDR_tag
{
	BYTE type;
	union
	{
		in4_addr ipv4;
		in6_addr ipv6;
	} u_IP_ADDR;
} IP_ADDR;








/****************************************************************************/
/*                           IMPORTED FUNCTIONS                             */
/****************************************************************************/
/*===========   Transport_ApplicationCommandHandler   ======================
**      Called, when frame is received
**    Side effects :
**
**--------------------------------------------------------------------------*/

extern void
Transport_ApplicationCommandHandler(
  BYTE  rxStatus,                 /* IN Frame header info */
  BYTE  sourceNode,               /* IN Command sender Node ID */
  ZW_APPLICATION_TX_BUFFER *pCmd, /* IN Payload from the received frame, the union */
                                  /*    should be used to access the fields */
  BYTE   cmdLength);              /* IN Number of command bytes including the command */


/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*========================   Transport_SendRequest   ============================
**      Send request command over secure network
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern BYTE
Transport_SendRequest(
  BYTE nodeID,
  BYTE *pBufData,
  BYTE dataLength,
  BYTE txOptions,
  VOID_CALLBACKFUNC_BYTE completedFunc,
  BYTE isForceNative);                    /* TRUE if data should be sent native, i.e. without using this transport.*/

/*========================   Transport_SendReport   ============================
**      This function must be called instead of Transport_SendRequest, if report
**      frame is sent.
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern BYTE
Transport_SendReport(
  BYTE nodeID,
  BYTE *pBufData,
  BYTE dataLength,
  BYTE txOptions,
  VOID_CALLBACKFUNC_BYTE completedFunc,
  BYTE isForceNative);                     /* TRUE if data should be sent native, i.e. without using this transport.*/

/*==============   Transport_OnApplicationInitHW   ============================
**      This function must be called in ApplicationInitHW
**
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern BYTE                               /* return TRUE on success */
Transport_OnApplicationInitHW(
  BYTE bStatus);                          /* bStatus */

/*==============   Transport_OnApplicationInitSW   ============================
**      This function must be called in ApplicationInitSW
**
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern BYTE                               /* return TRUE on success */
Transport_OnApplicationInitSW(
  BYTE *commandClassesList,               /* List of supported command classes, when node communicate by this transport */
  BYTE commandClassesListCount,           /* Count of elements in supported command classes list */
  BYTE eepromInit,                        /* TRUE if contents of eeprom must forced to be initialized to default values */
  BYTE eepromBufOffsSettings,             /* buffer offset in eeprom for storing transport settings*/
  BYTE eepromBufSizeSettings,             /* buffer size in eeprom for storing transport settings*/
  TRANSPORT_STATUS_CALLBACK statusCallbackFunc);  /* callback function, which called by transport to inform application layer of its status. can be NULL, if status not needed. */

/*==============   Transport_OnLearnCompleted   ============================
**      This function must be called in LearnCompleted application function
**       callback
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern BYTE                                /* return TRUE on success */
Transport_OnLearnCompleted(
  BYTE nodeID);                            /* IN resulting nodeID */


/*========================   Transport_SendDataIP  ===========================
**      Send data in Z/IP packet to the specifed IP
**    Side effects :
**
**--------------------------------------------------------------------------*/
extern BYTE
Transport_SendDataIP(
  BYTE gatewayNodeID,
  IP_ADDR *ipDestinationAddress,
  IP_ADDR *ipSourceAddress,
  BYTE *pBufData,
  BYTE dataLength,
  BYTE txOptions,
  VOID_CALLBACKFUNC_BYTE completedFunc);


#endif /*_TRANSPORT_ZIP_H_*/
