/*********************************  main.c  *********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2007
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: See below.
 *
 * Author:   Oleg Zadorozhnyy
 *
 * 2007-08-11   OZA     Integrated with Z-Wave Used with iccAVR
 *
 * Last Changed By:  $Author: oza $
 * Revision:         $Revision: 1.17 $
 * Last Changed:     $Date: 2009/03/19 11:39:20 $
 * Ported to iccAVR
 ****************************************************************************/

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include "TYPES.H"
#include "IO.H"
#ifdef __GNUC__
#include <avr/interrupt.h>
#define __enable_interrupt() sei();
#else
#include  <inavr.h>
#endif
#include "timer.h"
#include "led.h"
#include <ZW_Security_AES_module.h>
#include <string.h>
#include <stdio.h>
#include "ZW_basis.h"

#include "Trace/Trace.h"

extern void ZW_TimerInit(void);
extern void SerialAPI_ApplicationNodeInformation( BYTE listening, APPL_NODE_TYPE nodeType, BYTE *nodeParm, BYTE parmLength );
extern void ioPoll( void );
extern void SerialAPI_Poll( void );
extern void InitSec();
extern void
ApplicationControllerUpdate(
  BYTE bStatus,     /*IN  Status of learn mode */
  BYTE bNodeID,     /*IN  Node id of the node that send node info */
  BYTE* pCmd,       /*IN  Pointer to Application Node information */
  BYTE bLen);       /*IN  Node info length                        */
extern BOOL SerialAPI_InitSW(
  void ( *funcApplCmdHandler ) (BYTE, BYTE, ZW_APPLICATION_TX_BUFFER *, BYTE),
  void ( *funcAppConUpdate ) (BYTE, BYTE, BYTE*, BYTE )
);
/****************************************************************************/
/*                              PRIVATE DATA                                */
/****************************************************************************/
BYTE myDeviceOptionsMask;       /* Bitmask with application options   */
APPL_NODE_TYPE myNodeType;      /* Device type Generic and Specific   */
BYTE *myNodeParm;               /* Device parameter buffer pointer    */
BYTE myParmLength;              /* Number of Device parameter bytes   */

//DBG_MODULE_NAME("main.c");


int  main(void)
{
  mPORTInit();
  TimerInit();

  IOOpen(115200L);      // Open communications 115200 baud
  LED_Init();           // Setup and update LEDs

  // Initialize Z-Wave Portable controller application
  ZW_TimerInit();
  __enable_interrupt();
  DBG_INIT();
  
  SerialAPI_InitSW(ApplicationCommandHandler, ApplicationControllerUpdate);

  ApplicationInitSW();
  InitSec();
  InitSecurity(0);  

  // Initialize Application Node information
  // before transmitting "Node Information" to the Zwave module.
  ApplicationNodeInformation(
    &myDeviceOptionsMask,         /*OUT Bitmask with application options    */
    &myNodeType,                  /*OUT  Device type Generic and Specific   */
    &myNodeParm,                  /*OUT  Device parameter buffer pointer    */
    &myParmLength);               /*OUT  Number of Device parameter bytes   */

  // Send Application Node information to the Zwave module
  // before transmitting a "Node Information" frame
  // with "ZW_SendNodeInformation()".
  SerialAPI_ApplicationNodeInformation(
    myDeviceOptionsMask,
    myNodeType,
    myNodeParm,
    myParmLength);

  

  while(1)
  {
    ioPoll();
    SerialAPI_Poll();
    ApplicationPoll();
  }
}

/*
template <class T> class strict{
public:
  T val;
  explicit strict(T init_val):val(init_val){};
  strict operator+(strict b){ return strict(val + b.val);};
  strict operator-(strict b){ return strict(val - b.val);};
  strict operator*(strict b){ return strict(val * b.val);};
  strict operator/(strict b){ return strict(val / b.val);};
};

class strict_int1 :  strict<int> 
{
public:
  explicit strict_int1(int a):strict<int>(a){};
};

typedef  strict<int> strict_int2;

strict_int1 a(0);
strict_int2 b(0);
*/

