/********************************  LEDmain.c  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2007
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: See below.
 *
 * Author:   Oleg Zadorozhnyy
 *
 * 2007-08-11   OZA     Integrated with Z-Wave Used with iccAVR
 *
 * Last Changed By:  $Author: oza $
 * Revision:         $Revision: 1.8 $
 * Last Changed:     $Date: 2008/08/18 11:39:20 $
 * Ported to iccAVR
 ****************************************************************************/

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include "TYPES.H"
#ifdef __GNUC__
#include <avr/io.h>
#else
#include  <iom128.h>
#endif


#include "LED.h"


/****************************************************************************/
/*                              Init PortA to 0 and all output              */
/****************************************************************************/
void LED_Init(void)
{
  PORTA=0xFF;
  DDRA=0xFC;
}

void LED_ON(char led)
{
  led++;
  if (led < 8)
  {
    PORTA &= ~(1 << led);
  }
}


void LED_OFF(char led)
{
  led++;
  if (led < 8)
  {
    PORTA |= 1 << led;
  }
}

char LED_STATUS(char led)
{
  led++;
  if (led < 8)
  {
    return((PORTA & (1 << led)) >> led);
  }
   return 0;
}

void LEDA_ON()
{
  PORTC &= ~(1 << 0);
}


void LEDA_OFF()
{
  PORTC |= 1 << 0;
}

void LEDB_ON()
{
  PORTC &= ~(1 << 1);
}


void LEDB_OFF()
{
  PORTC |= 1 << 1;
}

void LEDC_ON()
{
  PORTC &= ~(1 << 2);
}


void LEDC_OFF()
{
  PORTC |= 1 << 2;
}

void LEDD_ON()
{
  PORTC &= ~(1 << 3);
}


void LEDD_OFF()
{
  PORTC |= 1 << 3;
}

