/********************************  ZW_EEPROM.H  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Internal EEPROM address definitions
 *
 * Author:   Peter Shorty, Oleg Zadorozhnyy
 *
 * 2007-06-11   EFH     Integrated with Z-Wave Used with iccAVR
 *
 * Last Changed By:  $Author: efh, oza $
 * Revision:         $Revision: 1.1 $
 * Last Changed:     $Date: 2007/11/06 11:39:20 $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* EEPROM address definitions */
#define MAX_NODES 232


/* EEPROM LED dimmer node layout */
#define EEOFFSET_LEVEL              0x00
////#define EEOFFSET_MAGIC              EEOFFSET_LEVEL   /* MAGIC */

#define AUTOGENERATED_OFFSET  0x200
/*Nodemask define*/
typedef struct _NODEMASK_S_
{
  BYTE  ID[MAX_NODES/8];
} NODEMASK;

typedef   NODEMASK  * NODEMASK_P;

/*Group table layout*/
typedef struct _GROUPTABLE_
{
  BYTE        magicValue2;
  BYTE        magicValue3;
  BYTE        magicValue4;
  BYTE        magicValue5;
    
  BYTE        magicValue;
  BYTE        currentDimLevel;      /* Last set Dim Level */
  NODEMASK    nodeMask;             /*Nodemask bit[n] = 1 indicates node n+1 is in the group*/
  NODEMASK    nodeSecurityMask;
//  BYTE    EEOFFSET_NETWORK_SECURITY;
//  BYTE    EEOFFSET_NETWORK_KEY_START[32];
//  BYTE    EEOFFSET_NETWORK_KEY_OLD[4][32];
//  BYTE    EEOFFSET_NETWORK_KEY_MAGIC;
//  BYTE    EEOFFSET_NETWORK_KEY_PTR_OLD;
//  BYTE    EEOFFSET_SECURITY_SCHEME;
//  BYTE    EEOFFSET_NETWORK_SECURITY;
  
} GROUPTABLE;

typedef GROUPTABLE  * GROUPTABLE_P;

/*Define of EEPROM layout*/
typedef struct _EEPROM_
{
  GROUPTABLE    groupTable;
} EEPROM;

#define offsetof(s,m)   (WORD)( (BYTE_P)&(((s *)0)->m) - (BYTE_P)0 )
/* address of field q in a struct s of type m */
#define addressof(s,m,q)  (AUTOGENERATED_OFFSET + (WORD) offsetof(EEPROM,s) + offsetof(m,q))



#define EEOFFSET_NETWORK_SECURITY     sizeof(EEPROM)+AUTOGENERATED_OFFSET+10
#define EEOFFSET_NETWORK_KEY_START    EEOFFSET_NETWORK_SECURITY  + 1
#define EEOFFSET_NETWORK_KEY_MAGIC    EEOFFSET_NETWORK_KEY_START + NETWORK_KEY_LENGTH
#define EEOFFSET_SECURITY_SCHEME      EEOFFSET_NETWORK_KEY_MAGIC+1

/* Default values */
#define MAGIC_VALUE                 0x42

#endif /* _EEPROM_H_ */
