/*******************************  RS232_IO.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2007
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: See below.
 *
 * Author:   Oleg Zadorozhnyy
 *
 * 2007-07-11   EFH     Integrated with Z-Wave environment.
 *
 * Last Changed By:  $Author: efh $
 * Revision:         $Revision: 1.2 $
 * Last Changed:     $Date: 2007/07/19 11:39:20 $
 *
 ****************************************************************************/


#ifndef RS232_IO_DOT_H
#define RS232_IO_DOT_H

/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/

#define mIOIsError()		(UCSR1A_FE1||UCSR1A_DOR1||UCSR1A_UPE1)

#define mIOIsGetReady()		(UCSR1A & (1 << RXC1))
#define mIOGetByte()		UDR1

#define mIOIsPutReady()		UCSR1A_UDRE1
#define	mIOPutByte(txData)	UDR1 = txData;


#endif
