/***********************  AES_module.h  *************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Z-Wave security AES module. Contains the functionality for
 *              implementing secure application communication using AES
 *              as encrypting/decrypting mechanism.
 *              Based on Cryptomatic Security spec and on JRMs C# OFB,
 *              ECB and CBCMAC implementation. Uses IAIK AES128
 *
 * Author:      Oleg Zadorozhnyy
 *
 * Last Changed By:  $Author: oza $

 * Revision:         $Revision: 1.00 $
 * Last Changed:     $Date: 2008/10/06 12:39:20 $
 *
 ****************************************************************************/
#ifndef _AES_MODULE_H_
#define _AES_MODULE_H_
/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

#define ZW_CONTROLLER

/****************************************************************************/
//* IMPORTANT:
//*
//* The AES128 module used is optimized for performance and memory.
//* Therefore it uses fixed memory areas and shares registers
//* between subroutines.
//*
//****************************************************************************/
#include "TYPES.H"      // Standard types
#include <string.h>
#include "ZW_Security_AES_module.h"
#include <ZW_basis.h>
#include "ZW_eeprom.h"

#include "io.h"

void setTimerTr();
void clrTimerTr();
/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/
#define TRANSPORT_WORK_END		0x00
#define TRANSPORT_WORK_START		0x01
#define TRANSPORT_WORK_ERROR		0x02

#define ZW_DEBUG_INIT(baud)
#define ZW_DEBUG_SEND_BYTE(bData)       //vSerial0PutByte(bData);
#define ZW_DEBUG_SEND_NUM(bData)        //vSerial0PutNum(bData);
#define ZW_DEBUG_SEND_NL()

#define CIPHER_KEY_LENGTH   128        // AES allows for 128, 192 and 256 bits

#define ILLEGAL_NODE_ID NODE_BROADCAST       /* To indicate host-id as uninitialized */
#define INTERNAL_NONCE_LIFE 200               /* Internal nonce life is 3 sec */

#define SECURITY   SECURITY_SCHEME_0
#define BLOCK_SIZE  128                // Number of bits of data to encrypt
                                       // AES standard fixes this to 128 bits
#define DATA_LENGTH (BLOCK_SIZE / 8)   // Block size in bytes (16 bytes)
#define Nb  (BLOCK_SIZE / 32)          // Number of columns in the State
                                       // AES standard fixes this to 4 
#define Nk  (CIPHER_KEY_LENGTH / 32)   // Number of 32-bit words (columns)
#define Nr  (Nk + 6)                   // Number of rounds necessary for
                                       // encryption or decryption
#define EXPANDED_KEY_SIZE ((Nr + 1) * 16)  // Number of bytes of keys

extern BYTE ASM_input[16], ASM_key[16];
extern BYTE EXP_KEYS [4*Nb*(Nr+1)];
extern BYTE Rcon[10];//// = {0x01, 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80, 0x1B, 0x36};
typedef struct word
{
   BYTE b0;
   BYTE b1;
   BYTE b2;
   BYTE b3;
} word;

/* Global temporary variables in SRAM */
/* Auxiliary authentication data */
typedef struct _AUTHDATA_
{
  BYTE iv[16];          /* Initialization vector for enc, dec,& auth */
  BYTE sh;              /* Security Header for authentication */
  BYTE senderNodeID;    /* Sender ID for authentication */
  BYTE receiverNodeID;  /* Receiver ID for authentication */
  BYTE payloadLength;   /* Length of authenticated payload */
} AUTHDATA;

/*
The internal nonce table "intNonce[]" is used to store internal nonces. A record in the table is vacant if
nonce[0] is zero. lifeLeft is decreased by one every 100 ms. When it has reached zero, nonce[0]
is set to zero.
*/
/* Internal nonce table */
typedef struct _INT_NONCE_
{
  /* First byte=0 -> vacant record */
  BYTE nonce[8];
  /* Life left (unit: 100 ms) */
  BYTE lifeLeft;
  /* ID of the node it was sent to */
  BYTE nodeID;
} INT_NONCE;


/* Pseudo-random number generator seed - is only reset on reset, */
/* on wakeup by either WUT or BEAM the previous seed is maintained via usage of the NON_ZERO_START block */
extern BYTE prngState[16];

extern BYTE blockIndex;
extern BYTE plaintext16ByteChunk[16];
extern BYTE cipherIndex;
extern AUTHDATA authData;

extern BYTE inputData[98];

extern BYTE tag[46];
extern BYTE pattern[16];

/* Message processing */
extern BYTE noncePacket[10];                    /* Buffer for outgoing nonce packet */
extern BYTE payloadPacket[sizeof(ZW_SECURITY_MESSAGE_ENCAP_FRAME)]; /* Buffer for outgoing packet with payload */
extern BYTE /*code*/ nonceRequestPacket[2];  /* Outgoing nonce request packet */

extern BYTE k[16], h[16], ltemp[16], btemp[16], i, j;
extern BYTE leastLifeLeft, newIndex;
extern BYTE ri;

/* Global Cryptography variables in saved NVRAM */
extern BYTE networkKey[16];                    /* The master key */
/* Global Cryptography variables in SRAM */
extern BYTE encKey[16];                        /* Encryption/decryption key */
extern BYTE authKey[16];                       /* Authentication key */
extern BYTE State[4][4];          // State vector; stored explicitly in
                                       // RAM for speed purposes
extern BYTE CurrentKey[4][4];     // Stores the keys for the current round
                                       // of encryption
extern INT_NONCE intNonce[IN_TABLE_SIZE];
extern BYTE networkOldKey[4][16];                    /* Old key */
extern BYTE ptrNetOldKey;
/*
The nonce request record stores the data necessary to send a payload packet once a response to a
nonce request is received. nrLifeLeft is decreased by one every 100 ms. When it has reached zero,
nrNodeID is set to ILLEGAL_NODE_ID to indicate that the record is vacant.
*/
/* Nonce request record */
extern BYTE *nrpBufData;                           /* Pointer to the payload data */
extern BYTE nrDataLength;                      /* Length of the payload data */
extern BYTE nrNodeID;                          /* Destignation node ID */
extern BYTE nrLifeLeft;                        /* Life left (unit: 100 ms) */
extern BYTE nrTXSecOptions;                    /* Security Options */
extern void (*nrCompletedFunc)(BYTE txStatus); /* Completed callback function */
extern void ( *cbFuncZWSecure ) ( BYTE txStatus );

extern BYTE nodeID;                /* This nodes Node-ID */

/*
The external nonce record is used to store the last received external nonce (enNonce[]), its associated
node ID "enNodeID", and the time until expiry "enLifeLeft". enLifeLeft is decreased by one every
100 ms. When is has reached zero, enNodeID is set to ILLEGAL_NODE_ID to indicate that the record is
vacant.
*/
// External nonce record
extern BYTE enNonce[8];    /* External nonce */
extern BYTE enNodeID;      /* Associated host id */
extern BYTE enLifeLeft;    /* Life left (unit: 100 ms) */

extern  BYTE bufHomeID[4];

extern BYTE outPayload[65];
extern WORD  securitySendLife;
extern BYTE  securitySendTimerHandle;
extern BYTE  NonceTimerServiceHanler;
extern WORD securityLife;
extern BYTE securityTimerHandle ;
extern BYTE *input_idata, *key_idata;
extern BYTE nodeInWork;
extern BYTE notSleep;
extern BYTE nodeSecure;

extern BYTE nodeSecureIncl;

extern BYTE OutKeyNewController;
extern BYTE inclusionKey[16];                    /* The master key TMP*/
extern BYTE SECURITY_SCHEME;

extern void ASM_AES128_Encrypt(void);
extern void ASM_AES128_Decrypt(void);
extern void ( *cbFuncZWSecure ) ( BYTE txStatus );

extern BYTE                          /*RET  FALSE if transmitter busy      */
ZW_SendData(
  BYTE  destNodeID,               /*IN  Destination node ID (0xFF == broadcast) */
  BYTE *pData,                /*IN  Data buffer pointer           */
  BYTE  dataLength,           /*IN  Data buffer length            */
  BYTE  txOptions,            /*IN  Transmit option flags         */
  VOID_CALLBACKFUNC(completedFunc)(BYTE)); /*IN  Transmit completed call back function  */

void AES128_Encrypt(const BYTE *ext_input, BYTE *ext_output, const BYTE *ext_key);

void NonceRequestCompleted(BYTE txStatus);

void NonceCompleted(BYTE txStatus);
void AddSecuritySlave(BYTE bNodeID, BOOL slaveStatus);

///void SetControllerSecure( BYTE SecStatus );
void setCtrlNoneSecure();
BYTE isCtrlIncluded();


void GetRNGData(BYTE *pRNDData,BYTE noRNDDataBytes);
void RegisterENOut(BYTE tnodeID,BYTE *pNonce);
BOOL
ZW_GetRandomWord(
  BYTE *randomWord,
  BOOL bResetRadio);

void InitSec();
#endif /*_AES_MODULE_H_*/
