/******************************* p_button.h  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Button module header file for development kit controller board.
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22659 $
 * Last Changed:     $Date: 2012-05-02 17:09:49 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/
#ifndef _P_BUTTON_H_
#define _P_BUTTON_H_
#include <ZW_sysdefs.h>
#include <ZW_typedefs.h>
#include <dev_ctrl_if.h>

/****************************************************************************/
/*                       PUBLIC TYPES and DEFINITIONS                       */
/****************************************************************************/

/*PUSH BUTTON defines*/
#define DOWN_PB0 0x01
#define DOWN_PB1 0x02
#define DOWN_PB2 0x04
#define DOWN_PB3 0x08
#define DOWN_PB4 0x10
#define PB_RELEASE 0x20
#define PB_HELD  0x40
#define PB_REPEAT 0x80

#define PB_MASK (~(PB_HELD|PB_REPEAT|PB_RELEASE))
#define PB_STATUS_MASK (PB_HELD|PB_REPEAT|PB_RELEASE)
/*Extern definition of variable that keeps status of button pressed*/
extern BYTE bPressed;
#ifdef PATCH_ENABLE
extern BYTE bOldPressed;
extern BYTE readyCount;
#endif

/*Macroes for getting a PB status*/
#define IS_DOWN_PB0(val) (val##&DOWN_PB0)
#define IS_DOWN_PB1(val) (val##&DOWN_PB1)
#define IS_DOWN_PB2(val) (val##&DOWN_PB2)
#define IS_DOWN_PB3(val) (val##&DOWN_PB3)
#define IS_DOWN_PB4(val) (val##&DOWN_PB4)


#define IS_PB_NOT_HELD(val) (!(val##|~PB_HELD))
#define IS_PB_HELD(val)     (val##&PB_HELD)
#define IS_PB_REPEAT(val)   (val##&PB_REPEAT)

#define IS_RELEASED_PB0(val) (!(val##&DOWN_PB0))
#define IS_RELEASED_PB1(val) (!(val##&DOWN_PB1))
#define IS_RELEASED_PB2(val) (!(val##&DOWN_PB2))
#define IS_RELEASED_PB3(val) (!(val##&DOWN_PB3))
#define IS_RELEASED_PB4(val) (!(val##&DOWN_PB4))

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
/*============================   TimerCheckButtons   ======================
**    Function description
**    This function checks and updates the status of the Push buttons.
**    It is run every 10ms
**    Side effects:
**
**--------------------------------------------------------------------------*/
#ifdef PATCH_ENABLE
void TimerCheckButtons(void) reentrant;
#else
void TimerCheckButtons(void);
#endif



/*============================   ButtonPressed   ============================
**    Function description
**      Checks the status of buttons. If buttons are down they are returned
**      with status of how long they have been pressed down.
**    Side effects:
**
**--------------------------------------------------------------------------*/
#ifdef PATCH_ENABLE
BYTE ButtonPressed(void) reentrant;
#else
BYTE ButtonPressed(void);
#endif

#endif /*_P_BUTTON_H_*/
