/*******************************  EEPROM.H  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Header file for EEPROM access routines
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22659 $
 * Last Changed:     $Date: 2012-05-02 17:09:49 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/
#define EEPROM_START                0x00

#define MAX_NODES 232
#define DEFAULT_SUC_NODE_ID  0x00

extern BYTE groupMask[MAX_NODES/8];

/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/
/*============================   StoreGroupLevel   ======================
**    Function description
**      Stores the current dim level in External EEPROM
**    Side effects:
**
**--------------------------------------------------------------------------*/
void StoreGroupLevel(
BYTE level)            /*IN Current group dim level*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   GetGroupLevel   ======================
**    Function description
**      Gets the current dim level in External EEPROM
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE GetGroupLevel(void)            /*RET Current group dim level*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   ClearGroupTable   ======================
**    Function description
**      Clears the group table and calls call back when done.
**      Remember to update ram table when done.
**    Side effects:
**
**--------------------------------------------------------------------------*/
void ClearGroupTable(void (*func)(void))
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   RemoveNodeFromGroup   ======================
**    Function description
**      Removes a node from a group.
**    Side effects:
**      updates the groupArray
**--------------------------------------------------------------------------*/
void RemoveNodeFromGroup(
BYTE bNodeID)              /*IN NodeID to remove*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   AddNodeToGroup   ======================
**    Function description
**      Adds a node to a group.
**    Side effects:
**      updates the groupArray
**--------------------------------------------------------------------------*/
void AddNodeToGroup(BYTE bNodeID)
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   UpdateRAMGroupList   ======================
**    Function description
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE                      /*RETURN number of nodes in the list*/
UpdateRAMGroupList(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   IsNodeInGroup   ======================
**    Function description
**      Check if a node is in the group
**    Side effects:
**
**--------------------------------------------------------------------------*/
BOOL IsNodeInGroup(BYTE bNodeID)
#ifdef PATCH_ENABLE
reentrant
#endif
;

/*============================   GetGroupListDimmers   ======================
**    Build a nodemask of nodes that has their generic type set to SWITCH_MULTILEVEL
**
**    Returns: Number of multilevel nodes found
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE                      /*RETURN number of nodes in the list*/
GetGroupListDimmers(BYTE *pbList)
#ifdef PATCH_ENABLE
reentrant
#endif
;

void
StoreNodeBitInGroup(BYTE bNodeID, BYTE value)
#ifdef PATCH_ENABLE
reentrant
#endif
;

#endif /* __H_ */
