/******************************* dev_ctrl.h  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Main routines of the simple Development controller...
 *
 * Author:   Erik Friis Harck
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 15568 $
 * Last Changed:     $Date: 2009-11-12 10:30:44 +0100 (Thu, 12 Nov 2009) $
 *
 ****************************************************************************/


/****************************************************************************/
/*                              PRIVATE FUNCTIONS                           */
/****************************************************************************/
extern void StopResetTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void ControlGroup(BYTE bCommand, void code *func(BYTE bStatus))
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void NewControllerReceiveStarted(LEARN_INFO *learnNodeInfo)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void ReplicationSendGroup(BYTE bStatus)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StopUpdateTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StopDimEndTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void TxCompleteIgnoreAck(BYTE bStatus)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void AssignRouteNodeCompleted(
  LEARN_INFO *learnNodeInfo)  /*IN Status*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void AssociationAddToGroupComplete(
  BYTE bStatus)             /*Transmit status*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void AssociationAddToGroup(
  BYTE bStatus)         /* IN Status of assign return route */
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void DimStarted(
  BYTE bStatus)       /*IN Transmit status*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void DimStopped(
  BYTE bStatus)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void GroupSend(
  BYTE *pData,                /*IN  Data buffer pointer           */
  BYTE dataLength,            /*IN  Data buffer length            */
  BYTE txOptions,             /*IN  Transmit option flags         */
  BYTE bCommand,
  void (code *func)(BYTE))    /*IN  Transmit completed call back function  */
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void NewControllerAllDone(
  LEARN_INFO *learnNodeInfo)    /*IN Learn node info*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void NewControllerSendStarted(
  LEARN_INFO *learnNodeInfo)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void RemoveNodeCompleted(
  LEARN_INFO *learnNodeInfo)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StartLED0Blink(
  BYTE blinkRate)       /*IN blink rate in 10ms*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void SucUpdateDone(
  BYTE txStatus) /*IN callback status from protocol*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void TxCompleteCheckAck(
  BYTE bStatus)             /*IN Transmit status*/
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void AbortReplication(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void ApplicationResetDone(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void DoReset(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void LED0Blinker(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void RxOffDelay(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void SetGroupDimLevel(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void SetSucNodeDelay( void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StartDimEndTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StartReplicationTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StartResetTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StartUpdateTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StopLED0Blink(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StopReplicationTimer(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void ToggleGroup(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void ZW_ResetDone(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;
