/*****************************  prod_test_gen.c  ****************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: This program starts by setting pin 0 on PORTA (now LED0) HIGH
 *  and if the button is pressed it sends 10 NOP frames while clearing LED0
 *  and setting pin 1 on PORTA (now LED1) HIGH, if ACK is received for all
 *  frames, LED1 continues to be HIGH, if not then LED1 is set LOW and LED0
 *  is set HIGH. By pressing button the sequence is started again...
 *
 * Author:   Johann Sigfredsson
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22680 $
 * Last Changed:     $Date: 2012-05-02 18:50:39 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/

#if defined(WORK_PATCH) || defined(STARTER_PATCH)
#define ZW_DEBUG
#endif

#ifdef PATCH_ENABLE
/****************************************************************************/
/* Include assembly MACRO definitions for patch insertions.                 */
/*                                                                          */
/* Define $SET (MAKE_PATCHABLE_CODE) for making patchable code destinned    */
/* for OTP or ROM memory.                                                   */
/* Undefine $RESET (MAKE_PATCHABLE_CODE) for making code containing patch   */
/* code destinned for RAM or FLASH memory.                                  */
/****************************************************************************/
#if defined(WORK_PATCH) || defined(STARTER_PATCH)
/* Making code containing patch code destinned for development RAM memory.  */
#pragma asm
$RESET (MAKE_PATCHABLE_CODE)
$INCLUDE (ZW_patch.inc)
#pragma endasm
/* Rename CODE class to CODE_PATCH */
#pragma userclass (code = PATCH)
/* Rename CONST class to CONST_PATCH */
#pragma userclass (const = PATCH)
/* Rename XDATA class to XDATA_PATCH */
#pragma userclass (xdata = PATCH)
#else
/* Making patchable code destinned for OTP or ROM memory.                   */
#pragma asm
$SET (MAKE_PATCHABLE_CODE)
$INCLUDE (ZW_patch.inc)
#pragma endasm
#endif /* elsif defined(WORK_PATCH) || defined(STARTER_PATCH) */
#endif /* PATCH_ENABLE */

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <config_app.h>
#include <ZW_patch.h>
#include <ZW_sysdefs.h>
#include <ZW_typedefs.h>
#include <ZW_pindefs.h>
#include <ZW_evaldefs.h>
#include <ZW_classcmd.h>
#include <ZW_basis_api.h>
#include <ZW_slave_api.h>
#include <ZW_uart_api.h>
#include <ZW_pindefs.h>
#include <prod_test_gen.h>

#ifdef ZW040x
#include <ZW_rf040x.h>
#endif

#ifdef ZW_ISD51_DEBUG
#include "ISD51.h"
#endif

extern IBYTE RF_freqno;
/*===============================   RFDriverInitHW   ==========================
**    Perfrom RF HW initalization
**
**--------------------------------------------------------------------------*/
extern void                /*RET Nothing           */
RFDriverInitHW( void ); /*IN  Nothing           */
/*==============================   RFDriverInitSW   =========================
**    Starts the sample interrupt and the generation of halfbit values,
**    and system time ticks.
**
**--------------------------------------------------------------------------*/
extern  void                /*RET Nothing           */
RFDriverInitSW( void ); /*IN  Nothing */

/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/
/****************************************************************************/
/*                              PRIVATE DATA                                */
/****************************************************************************/

#define ON  TRUE
#define OFF FALSE
#define TEST_COUNT 10     /*Initial test count*/
#define TEST_INTERVAL 8   /* 80ms */

#define TESTHOMEID  0x00000000
#define TESTDESTID  0x00

#define TRANSMIT_FAIL               0x04  /* A single_multicast/route frame transmit failed */

extern  BYTE homeID[4];

PATCH_VARIABLE BYTE keyWasDepressed
#ifndef WORK_PATCH
 = 0
#endif
;
PATCH_VARIABLE BYTE timerTestReady
#ifndef WORK_PATCH
 = 1
#endif
;
PATCH_VARIABLE BYTE commandBuf[4]
#ifndef WORK_PATCH
 = {0, 0, 0, 0}
#endif
;
PATCH_VARIABLE WORD count
#ifndef WORK_PATCH
 = 0
#endif
;
PATCH_VARIABLE WORD success
#ifndef WORK_PATCH
 = 0
#endif
;
PATCH_VARIABLE WORD test_count
#ifndef WORK_PATCH
 = TEST_COUNT
#endif
;
PATCH_VARIABLE BYTE frequencySelectionBuf
#ifndef WORK_PATCH
 = 0
#endif
;

static BYTE destID;		 /* destination NodeID. */

/* Version string protocol   123456789012 (12 char max)*/
PATCH_VARIABLE BYTE api_version[]
#ifndef WORK_PATCH
 = "Unknown    "
#endif
;
PATCH_VARIABLE BYTE code appl_version[]
#ifndef WORK_PATCH
 = {'\n','\r','V','e','r','s','i','o','n',' ',
    ((APP_VERSION/10) ? (APP_VERSION/10)+0x30 : ' '),
    (APP_VERSION%10)+0x30, '.',
    (APP_REVISION/10)+0x30,
    (APP_REVISION%10)+0x30, ' ',
    0x00
   }
#endif
;

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                            PRIVATE FUNCTIONS                             */
/****************************************************************************/

void PATCH_FUNCTION_NAME(ToggleRED)(void)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(ToggleRED)
#pragma endasm
#endif

  LED_TOGGLE(1);

}


void PATCH_FUNCTION_NAME(SetGREEN)(BYTE on)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(SetGREEN)
#pragma endasm
#endif
  if (on)
  {
    LED_ON(2);

  }
  else
  {
    LED_OFF(2);
  }
}


void PATCH_FUNCTION_NAME(SetRED)(BYTE on)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY(SetRED)
#pragma endasm
#endif
  if (on)
  {
    LED_ON(1);

  }
  else
  {
    LED_OFF(1);
  }
}


/*==========================   ApplictionSlaveUpdate   =======================
**   Inform a slave application that a node information is received.
**   Called from the slave command handler when a node information frame
**   is received and the Z-Wave protocol is not in a state where it is needed.
**
**--------------------------------------------------------------------------*/
void
PATCH_FUNCTION_NAME_STARTER(ApplicationSlaveUpdate)(
  BYTE bStatus,     /*IN  Status event */
  BYTE bNodeID,     /*IN  Node id of the node that send node info */
  BYTE* pCmd,       /*IN  Pointer to Application Node information */
  BYTE bLen)       /*IN  Node info length                        */
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationSlaveUpdate)
#pragma endasm
#endif

}


/*==========================   SendCompletedHandler   =======================
**    Handling of a completed send command.
**    This function is called when the Z-Wave modul has completed sending a frame.
**
**    This is an application function example
**
**--------------------------------------------------------------------------*/
static void       /*RET  Nothing                  */
SendCompleteHandler(
BYTE  commandCode) reentrant  /*IN  Send completed code  */
{
  if (commandCode == TRANSMIT_COMPLETE_NO_ACK)
  {
    /*Not received*/
  }
  else
  {
    /*Received*/
    LED_TOGGLE(3);
    success++;
  }
  if (++count >= test_count)
  {
    if (success < test_count)
    {
      SetGREEN(OFF);
      SetRED(ON);
      ZW_UART0_SEND_BYTE('-');
    }
    else
    {
      SetGREEN(ON);
      SetRED(OFF);
      ZW_UART0_SEND_BYTE('+');
    }
    ZW_UART0_SEND_NUM((BYTE)(success>>8));
    ZW_UART0_SEND_NUM((BYTE)(success & 0x00FF));
    count = success = 0;
    timerTestReady = 1;
  }
  else
  {
    if(!ZW_SEND_DATA(destID, commandBuf, sizeof(BYTE)*2, TRANSMIT_OPTION_ACK | 0x40, SendCompleteHandler))
    {
      SendCompleteHandler(TRANSMIT_COMPLETE_NO_ACK);
    }
  }
}


/*=======================   TimerTestHandler   ========================
**
**
**    Side effects :
**
**--------------------------------------------------------------------------*/
static void                   /*RET  Nothing                  */
TimerTestHandler( void ) /*IN  Nothing                   */
{
  ToggleRED();
  /* Send CMD_NOP frame */
  /* the transmit option 0x40 is TRANSMIT_OPTION_SINGLE, which isn't known */
  /* to the application-layer */
  if(!ZW_SEND_DATA(destID, commandBuf, sizeof(BYTE)*2, TRANSMIT_OPTION_ACK | 0x40, SendCompleteHandler))
  {
    SendCompleteHandler(TRANSMIT_COMPLETE_NO_ACK);
  }
}

/*=============================   ApplicationPoll   ========================
**    Application poll function
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void           /*RET  Nothing                  */
PATCH_FUNCTION_NAME_STARTER(ApplicationPoll)( void )  /* IN  Nothing                  */
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationPoll)
#pragma endasm
#endif
#ifdef ZW_ISD51_DEBUG         /* init ISD51 only when the uVision2 Debugger tries to connect */
  ISDcheck();                 /* initialize uVision2 Debugger and continue program run */
#endif
  if (BUTTON_PRESSED())
  {
    if (timerTestReady)
    {
      keyWasDepressed = 1;
      timerTestReady = 0;
    }
  }
  else
  {
    /*No key is pressed*/
    if (keyWasDepressed)
    {
      keyWasDepressed = 0;
      SetGREEN(OFF);
      ToggleRED();
      ZW_TIMER_START(TimerTestHandler, TEST_INTERVAL, 1);
    }
    if(ZW_UART0_REC_STATUS)
    {
      BYTE recData = ZW_UART0_REC_BYTE;
      ZW_UART0_SEND_BYTE(' ');
      switch (recData)
      {
        case 'U':
          {
            /*Fix TO# 2701 */
            RF_freqno = RF_US;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('U');
            ZW_UART0_SEND_BYTE('S');
          }
          break;
        case 'E':
          {
            /*Fix TO# 2701 */
            RF_freqno = RF_EU;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('E');
            ZW_UART0_SEND_BYTE('U');
          }
          break;
        case 'H':
          {
            RF_freqno = RF_HK;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('H');
            ZW_UART0_SEND_BYTE('K');

          }
          break;

        case 'Z':
          {
            RF_freqno = RF_ANZ;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('A');
            ZW_UART0_SEND_BYTE('N');
            ZW_UART0_SEND_BYTE('Z');

          }
          break;

        case 'I':
          {
            RF_freqno = RF_IN;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('I');
            ZW_UART0_SEND_BYTE('N');
          }
          break;
        case 'M':
          {
            RF_freqno = RF_MY;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('M');
            ZW_UART0_SEND_BYTE('Y');

          }
          break;

        case 'J':
          {
            RF_freqno = RF_JP;
            RFDriverInitHW();
            RFDriverInitSW();
            ZW_SET_RX_MODE(TRUE);
            ZW_UART0_SEND_BYTE('J');
            ZW_UART0_SEND_BYTE('P');

          }
          break;

        case '0':
        case '1':
        case '2':
        case '3':
        case '4':
        case '5':
        case '6':
        case '7':
        case '8':
        case '9':
          {
            if (frequencySelectionBuf == 0)
            {
              ZW_UART0_SEND_BYTE(recData);
              frequencySelectionBuf = recData;
            }
            else
            {
              ZW_UART0_SEND_BYTE(recData);
              RF_freqno = ((frequencySelectionBuf - '0') * 10) + (recData - '0');;
              ZW_UART0_SEND_BYTE(' ');
              ZW_UART0_SEND_BYTE('0');
              ZW_UART0_SEND_BYTE('x');
              ZW_UART0_SEND_NUM(RF_freqno);
              frequencySelectionBuf = 0;
              RFDriverInitHW();
              RFDriverInitSW();
              ZW_SET_RX_MODE(TRUE);
            }
          }
          break;

        case 'S':
          {
            if (timerTestReady)
            {
              keyWasDepressed = 1;
              timerTestReady = 0;
            }
            ZW_UART0_SEND_BYTE('S');
            ZW_UART0_SEND_BYTE('T');
          }
          break;
        case 'C':
          {
            test_count = 1000;
            ZW_UART0_SEND_BYTE('C');
            ZW_UART0_SEND_BYTE('O');
          }
          break;
        case 'N':
          {
           /*Fix  TO# 02710 now we can send to nodeID 1*/
            destID = ZW_UART0_REC_BYTE - '0';
            ZW_UART0_SEND_NUM(destID);
            ZW_UART0_SEND_BYTE('N');
            ZW_UART0_SEND_BYTE('I');
          }
        break;
        case 'R':
          {
            /*Reset the module*/
            ZW_UART0_SEND_BYTE('R');
            ZW_UART0_SEND_BYTE('S');
            while(ZW_UART0_SEND_STATUS);
            ZW_WATCHDOG_ENABLE; /*reset asic*/
            while(1);
          }
        break;
        default:
          {
            ZW_UART0_SEND_BYTE('!');
            ZW_UART0_SEND_BYTE(recData);
          }
        break;

      }
    }
  }
}


/****************************************************************************/
/*                           EXPORTED FUNCTIONS                             */
/****************************************************************************/

/*==============================   ApplicationInitHW   ===========================
**    Non Z-Wave hardware initialization
**
**    This is an application function example
**
**--------------------------------------------------------------------------*/
BYTE
PATCH_FUNCTION_NAME_STARTER(ApplicationInitHW)(
  BYTE bWakeupReason       /* Reason for the powerup of the chip */
)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationInitHW)
#pragma endasm
#endif
#ifdef ZW_ISD51_DEBUG
  ZW_UART1_init(1152, TRUE, TRUE);
#endif
  /* hardware initialization */
  PIN_IN(Button, 1);


  PIN_OUT(LED1);
  PIN_OUT(LED2);
  PIN_OUT(LED3);
#ifdef JP
  RF_freqno = RF_JP;
#else
  RF_freqno = RF_US;
#endif

  return(TRUE);
}

/*===========================   ApplicationInitSW   =========================
**    Initialization of the Application Software
**
**    This is an application function example
**
**--------------------------------------------------------------------------*/
BYTE                   /*RET  TRUE       */
PATCH_FUNCTION_NAME_STARTER(ApplicationInitSW)(  void )  /*IN Nothing */
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationInitSW)
#pragma endasm
#endif
  *((DWORD *)&homeID[0]) = TESTHOMEID;
/* Do not reinitialize the UART if already initialized for ISD51 in ApplicationInitHW() */
#ifndef ZW_ISD51_DEBUG
  ZW_DEBUG_INIT(1152);
  ZW_DEBUG_SEND_BYTE('@');
#endif
  SetRED(ON);
  SetGREEN(OFF);

  LED_OFF(3);

  destID = TESTDESTID;
  ZW_UART0_INIT(1152);
  ZW_UART0_SEND_STR(appl_version);
  ZW_Version(api_version);
  ZW_UART0_SEND_STR(api_version);
  return(TRUE);
}


/*============================   ApplicationTestPoll   ======================
**    Function description
**      This function is called when the slave enters test mode.
**    Side effects:
**       Code will not exit until it is reset
**--------------------------------------------------------------------------*/
void PATCH_FUNCTION_NAME_STARTER(ApplicationTestPoll)(void)
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationTestPoll)
#pragma endasm
#endif
  ApplicationPoll();
}


/*========================   ApplicationCommandHandler   ====================
**    Handling of a received application commands and requests
**
**    This is an application function example
**
**--------------------------------------------------------------------------*/
void       /*RET  Nothing                  */
PATCH_FUNCTION_NAME_STARTER(ApplicationCommandHandler)(
BYTE  rxStatus,   /*IN  Frame header info */
BYTE  sourceNode, /*IN  Command sender Node ID */
  ZW_APPLICATION_TX_BUFFER *pCmd, /* IN Payload from the received frame, the union */
                                  /*    should be used to access the fields */
BYTE   cmdLength) /*IN  Number of command bytes including the command */
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationCommandHandler)
#pragma endasm
#endif
}

/*==========================   GetNodeInformation   =========================
**    Request Node information and current status
**    Called by the the Z-Wave application layer before transmitting a
**    "Node Information" frame.
**
**    This is an application function example
**
**--------------------------------------------------------------------------*/
extern  void               /*RET Nothing */
PATCH_FUNCTION_NAME_STARTER(ApplicationNodeInformation)(
BYTE   *deviceOptionsMask,     /*OUT Bitmask with application options     */
  APPL_NODE_TYPE  *nodeType,  /*OUT  Device type Generic and Specific   */
BYTE  **nodeParm,     /*OUT  Device parameter buffer pointer      */
BYTE  *parmLength )   /*OUT  Number of Device parameter bytes   */
#ifdef PATCH_ENABLE
reentrant
#endif
{
  BYTE dimLevel;

#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationNodeInformation)
#pragma endasm
#endif
  dimLevel = 0;
*deviceOptionsMask = APPLICATION_NODEINFO_LISTENING;             /* this is a powered node */
  nodeType->generic = GENERIC_TYPE_SWITCH_MULTILEVEL; /* Generic device type */
  nodeType->specific = 0;             /* We have no Specific class */
  *nodeParm = (BYTE *)&dimLevel;
  *parmLength = sizeof(dimLevel);
}

/* Do not use absolut register adressing */
#pragma NOAREGS
/*==============================   ApplicationRfNotify   ======================
**    Function used when using an external PA
**
**--------------------------------------------------------------------------*/
void                   /*RET TRUE - If normal operation, FALSE - if production test*/
PATCH_FUNCTION_NAME_STARTER(ApplicationRfNotify)(
  BYTE bStatus)        /* IN RF status */
#ifdef PATCH_ENABLE
reentrant
#endif
{
#ifdef PATCH_ENABLE
#pragma asm
PATCH_TABLE_ENTRY_STARTER(ApplicationRfNotify)
#pragma endasm
#endif
}

