/********************************  EEPROM.H  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless lauguage.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Internal EEPROM address definitions
 *
 * Author:   Peter Shorty
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22671 $
 * Last Changed:     $Date: 2012-05-02 17:57:21 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/
#ifndef _EEPROM_H_
#define _EEPROM_H_

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* EEPROM address definitions */

/* EEPROM LED dimmer node layout */
#define EEOFFSET_LEVEL              0x00
#define EEOFFSET_STATUS             EEOFFSET_LEVEL + 1
#define EEOFFSET_IGNORE_ALL_ON_OFF  EEOFFSET_LEVEL + 2
#define EEOFFSET_PROTECTED          EEOFFSET_LEVEL + 3
#define EEOFFSET_PROTECTED_RF       EEOFFSET_LEVEL + 4
#define EEOFFSET_MAGIC              EEOFFSET_LEVEL + 5  /* MAGIC */

#define EEOFFSET_ASSOCIATION_START        EEOFFSET_MAGIC + 1
#define EEOFFSET_ASSOCIATION_MAGIC        EEOFFSET_ASSOCIATION_START + ASSOCIATION_SIZE

#define EEOFFSET_TRANSPORT_SETTINGS_START EEOFFSET_ASSOCIATION_MAGIC + 1
#define EEOFFSET_TRANSPORT_SETTINGS_SIZE  TRANSPORT_EEPROM_SETTINGS_SIZE

//#define EEOFFSET_TRANSPORT_SETTINGS_START EEOFFSET_MAGIC + 1
//#define EEOFFSET_TRANSPORT_SETTINGS_SIZE  TRANSPORT_EEPROM_SETTINGS_SIZE


/* Default values */
#define DEFAULT_LEVEL               99    /* Full light level */
#define DEFAULT_STATUS              0
#define DEFAULT_IGNORE_ALL_ON_OFF   0
#define DEFAULT_PROTECTED           0
#define MAGIC_VALUE                 0x42


#endif /* _EEPROM_H_ */
