/********************************  DoorLock.h  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2009
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: Include file for DoorLock module
 *
 * Author:   Valeriy Vyshnyak
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22667 $
 * Last Changed:     $Date: 2012-05-02 17:33:28 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/
#ifndef _DOORLOCK_H_
#define _DOORLOCK_H_

/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* Poll function button state defines */
#define POLLIDLE          0
#define POLLLEARNMODE     3 /* We're in learnmode */

/* lockStatus define - bit no. */
#define LOCK_ON_OFF             0   /* state of doorlock 1 = on , 0 = off */
/* lockStatus define - mask */
#define M_LOCK_ON_OFF           (1<<LOCK_ON_OFF)
/* SetLock() command defines */
enum
{
  CURRENT_STATE = 0,
  TOGGLE,
  ON,
  OFF,
  LEVEL
};

#define LOCK_UPDATETIME     10  /* We wait about 100ms before we update the relay */



/* Power level definitions */
#define ZW_TEST_FAILED                                  0x00
#define ZW_TEST_SUCCES                                  0x01
#define ZW_TEST_INPROGRESS                              0x02
#define ZW_TEST_NOT_A_NODEID                            0x00

/* Offsets into frame received */
#define OFFSET_PARAM_1                        0x02
#define OFFSET_PARAM_2                        0x03
#define OFFSET_PARAM_3                        0x04
#define OFFSET_PARAM_4                        0x05
/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/
extern void
SendTestDone(
  BYTE bStatus)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void
PowerLevelTimeout( void )
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void
PowerLevelTimerCancel( void )
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void
SendTestReport( void )
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void
StartTest(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

#endif /* _DOORLOCK_H */
