/******************************* eeprom.c  *******************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 *
 * Description: This file contains functions for the external eeprom handling
 *
 * Author:   Henrik Holm
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22664 $
 * Last Changed:     $Date: 2012-05-02 17:32:36 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/

/****************************************************************************/
/*                              INCLUDE FILES                               */
/****************************************************************************/
#include <ZW_controller_api.h>
#include <ZW_pindefs.h>
#include <ZW_uart_api.h>
#include <ZW_classcmd.h>
#include <ZW_eep_addr.h>

/****************************************************************************/
/*                      PRIVATE TYPES and DEFINITIONS                       */
/****************************************************************************/
#define EEPROM_META_DATA_SLAVE    1
#define EEPROM_CHECKSUM           2

#define CHECKSUM_BASE             42

/****************************************************************************/
/*                              PRIVATE DATA                                */
/****************************************************************************/

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                              EXPORTED FUNCTIONS                           */
/****************************************************************************/

/*==============================   EEprom_Validate   ========================
**    Function description
**      Verify that the contens of the EEPROM is correct and reset
**      it if it isn't
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
void EEprom_Validate()
{
  register BYTE bChecksum = CHECKSUM_BASE;

  bChecksum += MemoryGetByte(EEPROM_META_DATA_SLAVE);

  /* Test if checksum is correct */
  if (bChecksum == MemoryGetByte(EEPROM_CHECKSUM))
    return;

  /* Checksum is not correct initialize EEPROM values */
  MemoryPutByte(EEPROM_META_DATA_SLAVE, 0);
  MemoryPutByte(EEPROM_CHECKSUM, CHECKSUM_BASE);
}

/*==============================   EEprom_StoreNode   ========================
**    Function description
**      Store a nodeID in EEPROM
**
**    Side effects:
**      Updates the checksum in EEPROM
**--------------------------------------------------------------------------*/
void EEprom_StoreNode(BYTE bNodeID)
{
  MemoryPutByte(EEPROM_META_DATA_SLAVE, bNodeID);
  MemoryPutByte(EEPROM_CHECKSUM, bNodeID + CHECKSUM_BASE);
}

/*==============================   EEprom_GetNode   ========================
**    Function description
**      Get a stored nodeID from EEPROM
**
**    Side effects:
**
**--------------------------------------------------------------------------*/
BYTE EEprom_GetNode()
{
  return MemoryGetByte(EEPROM_META_DATA_SLAVE);
