/********************************  bell.h  ********************************
 *           #######
 *           ##  ##
 *           #  ##    ####   #####    #####  ##  ##   #####
 *             ##    ##  ##  ##  ##  ##      ##  ##  ##
 *            ##  #  ######  ##  ##   ####   ##  ##   ####
 *           ##  ##  ##      ##  ##      ##   #####      ##
 *          #######   ####   ##  ##  #####       ##  #####
 *                                           #####
 *          Z-Wave, the wireless language.
 *
 *              Copyright (c) 2001
 *              Zensys A/S
 *              Denmark
 *
 *              All Rights Reserved
 *
 *    This source file is subject to the terms and conditions of the
 *    Zensys Software License Agreement which restricts the manner
 *    in which it may be used.
 *
 *---------------------------------------------------------------------------
 * Copyright Zensys A/S, 2001
 *
 * Description: Include file for LEDdimmer module
 *
 * Author:   Johann Sigfredsson
 *
 * Last Changed By:  $Author: psh $
 * Revision:         $Revision: 22663 $
 * Last Changed:     $Date: 2012-05-02 17:22:55 +0200 (Wed, 02 May 2012) $
 *
 ****************************************************************************/
#ifndef _META_SLAVE_H_
#define _META_SLAVE_H_


/****************************************************************************/
/*                     EXPORTED TYPES and DEFINITIONS                       */
/****************************************************************************/

/* Offsets into frame received */
#define OFFSET_CLASSCMD                       0x00
#define OFFSET_CMD                            0x01
#define OFFSET_PARAM_1                        0x02
#define OFFSET_PARAM_2                        0x03
#define OFFSET_PARAM_3                        0x04
#define OFFSET_PARAM_4                        0x05

#define CLASS_MEMBERSHIP_COUNT  3

typedef struct s_nodeInfo_
{
   BYTE memberClass[CLASS_MEMBERSHIP_COUNT];  /* Command class membership */
} t_nodeInfo;

/****************************************************************************/
/*                              EXPORTED DATA                               */
/****************************************************************************/

/****************************************************************************/
/*                            PRIVATE FUNCTIONS                             */
/****************************************************************************/

extern void NodeInfoSendComplete(BYTE bStatus)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void              /*RET Nothing */
SendReport(
  BYTE sourceNode,  /* IN Source node - to whom report is to be send */
  BYTE classcmd,    /* IN Command class, which the report belongs to */
  BYTE reportparam) /* IN paramter to include in report frame */
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void TxDone(BYTE bStatus)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void GotoSleep(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void SleepTimeout(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StopSleepTimeout(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

extern void StartSleepTimeout(void)
#ifdef PATCH_ENABLE
reentrant
#endif
;

#endif /* _META_SLAVE_H */
