using System;
using System.Collections.Generic;
using System.Text;
using OpenSource.UPnP;

namespace Zensys.ZWave.UPnPBridge.UPnPClasses
{
    public class ZWaveUPnPDevice :IEquatable<ZWaveUPnPDevice>
    {
        public ZWaveUPnPDevice(UPnPDevice uPnPDevice)
        {
            mUPnPDevice = uPnPDevice;
        }

        private UPnPDevice mUPnPDevice;
        public UPnPDevice UPnPDevice
        {
            get { return mUPnPDevice; }
        }

        public string FriendlyName
        {
            get { return mUPnPDevice.FriendlyName; }
        }
        public string StandardDeviceType
        {
            get { return mUPnPDevice.StandardDeviceType; }
        }
        public string Version
        {
            get { return mUPnPDevice.Version; }
        }
        public string PresentationURL
        {
            get { return mUPnPDevice.PresentationURL; }
        }

        #region IEquatable<ZWaveUPnPDevice> Members

        public bool Equals(ZWaveUPnPDevice other)
        {
            if (UPnPDevice == other.UPnPDevice)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        #endregion
    }
}
