using System;
using System.Collections.Generic;
using System.Text;
using OpenSource.UPnP;

namespace Zensys.ZWave.UPnPBridge.UPnPClasses
{
    public class ZWaveUPnPBinaryLightDevice : ZWaveUPnPDevice
    {
        public ZWaveUPnPBinaryLightDevice(UPnPDevice uPnPDevice)
            : base(uPnPDevice)
        {
            if (uPnPDevice.GetServices("urn:schemas-upnp-org:service:SwitchPower:1") != null)
            {
                foreach (UPnPService service in uPnPDevice.GetServices("urn:schemas-upnp-org:service:SwitchPower:1"))
                {
                    upnpLightService = service;
                    break;
                }
            }
        }
        private byte mNodeID;
        public byte NodeID
        {
            get { return mNodeID; }
            set { mNodeID = value; }
        }

        internal bool lightState;
        internal UPnPService upnpLightService;
        internal void SetTarget(object newTargetValue)
        {
            if (upnpLightService != null)
            {
                if (lightState == (bool)newTargetValue) return;
                UPnPAction action = upnpLightService.GetAction("SetTarget");
                action.ArgumentList[0].DataValue = newTargetValue;
                upnpLightService.InvokeSync(action.Name, action.ArgumentList);
                lightState = (bool)newTargetValue;
            }
        }
    }
}
