using System;
using System.Collections.Generic;
using System.Windows.Forms;
using Zensys.ZWave.UPnPBridge.UI;
using Zensys.Framework.Console;
using Zensys.ZWave.UPnPBridge.Console;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.Framework.Application;
using OpenSource.UPnP;

namespace Zensys.ZWave.UPnPBridge
{
    static class Program
    {
        [System.Runtime.InteropServices.DllImport("kernel32.dll")]
        static extern bool FreeConsole();
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main(string[] args)
        {
            ControllerManager controllerManager = new ControllerManager();
            if (args != null && args.Length > 0)
            {
                controllerManager.Initialize(ApplicationMode.Console);
                CommandLine cline = new BridgeCommandLine();
                CommandArgs cargs = cline.Parse(args);
                if (cargs.ArgPairs.ContainsKey("?") || cargs.ArgPairs.ContainsKey("help"))
                {
                    cline.ShowUsage();
                }
                else
                { }
                System.Windows.Forms.Application.Exit();
            }
            else
            {
                FreeConsole();
                System.Windows.Forms.Application.EnableVisualStyles();
                System.Windows.Forms.Application.SetCompatibleTextRenderingDefault(false);
                controllerManager.MainForm = new MainForm();
                controllerManager.Initialize(ApplicationMode.GUI);
                System.Windows.Forms.Application.Run(controllerManager.MainForm);
            }
        }
    }
}