using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.UI;
using System.Windows.Forms;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class UPnPBinaryLightCPDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            UPnPBinaryLightCPForm form = (UPnPBinaryLightCPForm)view;
            //Form
            form.Load += actions.UPnPBinaryLightCPActions.OnFormLoad;
            form.FormClosing += actions.UPnPBinaryLightCPActions.OnFormClosing;
            form.ButtonToggle.Click += actions.UPnPBinaryLightCPActions.OnButtonToggleClick;
            form.ButtonScan.Click += actions.UPnPBinaryLightCPActions.OnButtonScanClick;
        }

        public void Drop(IView view, ActionCollection actions, Zensys.ZWave.UPnPBridge.Models.DocumentModel documentModel)
        {
            UPnPBinaryLightCPForm form = (UPnPBinaryLightCPForm)view;
            //Form
            form.Load -= actions.UPnPBinaryLightCPActions.OnFormLoad;
            form.FormClosing -= actions.UPnPBinaryLightCPActions.OnFormClosing;
            form.ButtonToggle.Click -= actions.UPnPBinaryLightCPActions.OnButtonToggleClick;
            form.ButtonScan.Click -= actions.UPnPBinaryLightCPActions.OnButtonScanClick;
        }
        #endregion
    }
}
