using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Interfaces;
using Zensys.ZWave.UPnPBridge.Classes;
using Zensys.ZWave.UPnPBridge.UI;
using Zensys.ZWave.UPnPBridge.Models;

namespace Zensys.ZWave.UPnPBridge.Dispatchers
{
    public class MainFormDispatcher : IViewDispatcher
    {
        #region IViewDispatcher Members
        public void Bind(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;
            //Form
            form.Load += actions.MainFormActions.OnFormLoad;
            form.FormClosing += actions.MainFormActions.OnFormClosing;
            ///Help
            form.AboutToolStripMenuItem.Click += actions.MainFormActions.OnAboutToolStripMenuItemClick;
            form.IndexToolStripMenuItem.Click += actions.MainFormActions.OnIndexToolStripMenuItemClick;
            form.SearchToolStripMenuItem.Click += actions.MainFormActions.OnSearchToolStripMenuItemClick;
            form.ContentsToolStripMenuItem.Click += actions.MainFormActions.OnContentsToolStripMenuItemClick;
            ///Views
            form.ControllerToolStripMenuItem.Click += actions.MainFormActions.OnControllerToolStripMenuItemClick;
            form.CmdClassToolStripMenuItem.Click += actions.MainFormActions.OnCmdClassToolStripMenuItemClick;
            form.NodeToolStripMenuItem.Click += actions.MainFormActions.OnNodeToolStripMenuItemClick;
            form.AssociationsToolStripMenuItem.Click += actions.MainFormActions.OnAssociationsToolStripMenuItemClick;
            form.LogToolStripMenuItem.Click += actions.MainFormActions.OnLogToolStripMenuItemClick;
            form.UPnPBinaryLightCPToolStripMenuItem.Click += actions.MainFormActions.OnUPnPBinaryLightCPToolStripMenuItemClick;
            form.UPnPBridgedDevicesToolStripMenuItem.Click += actions.MainFormActions.OnUPnPBridgedDevicesToolStripMenuItemClick;
            form.UPnPDeviceScannerToolStripMenuItem.Click += actions.MainFormActions.OnUPnPDeviceScannerToolStripMenuItemClick;
            form.UPnPRendererCPToolStripMenuItem.Click += actions.MainFormActions.OnUPnPRendererCPToolStripMenuItemClick;
            ///Other
            form.ExitToolStripMenuItem.Click += actions.MainFormActions.OnExitToolStripMenuItemClick;
            form.SettingsToolStripMenuItem.Click += actions.MainFormActions.OnSettingsToolStripMenuItemClick;
        }

        public void Drop(IView view, ActionCollection actions, DocumentModel documentModel)
        {
            MainForm form = (MainForm)view;
            //Form
            form.Load -= actions.MainFormActions.OnFormLoad;
            form.FormClosing -= actions.MainFormActions.OnFormClosing;
            ///Help
            form.AboutToolStripMenuItem.Click -= actions.MainFormActions.OnAboutToolStripMenuItemClick;
            form.IndexToolStripMenuItem.Click -= actions.MainFormActions.OnIndexToolStripMenuItemClick;
            form.SearchToolStripMenuItem.Click -= actions.MainFormActions.OnSearchToolStripMenuItemClick;
            form.ContentsToolStripMenuItem.Click -= actions.MainFormActions.OnContentsToolStripMenuItemClick;
            ///Views
            form.ControllerToolStripMenuItem.Click -= actions.MainFormActions.OnControllerToolStripMenuItemClick;
            form.CmdClassToolStripMenuItem.Click -= actions.MainFormActions.OnCmdClassToolStripMenuItemClick;
            form.NodeToolStripMenuItem.Click -= actions.MainFormActions.OnNodeToolStripMenuItemClick;
            form.AssociationsToolStripMenuItem.Click -= actions.MainFormActions.OnAssociationsToolStripMenuItemClick;
            form.LogToolStripMenuItem.Click -= actions.MainFormActions.OnLogToolStripMenuItemClick;
            form.UPnPBinaryLightCPToolStripMenuItem.Click -= actions.MainFormActions.OnUPnPBinaryLightCPToolStripMenuItemClick;
            form.UPnPBridgedDevicesToolStripMenuItem.Click -= actions.MainFormActions.OnUPnPBridgedDevicesToolStripMenuItemClick;
            form.UPnPDeviceScannerToolStripMenuItem.Click -= actions.MainFormActions.OnUPnPDeviceScannerToolStripMenuItemClick;
            form.UPnPRendererCPToolStripMenuItem.Click -= actions.MainFormActions.OnUPnPRendererCPToolStripMenuItemClick;
            ///Other
            form.ExitToolStripMenuItem.Click -= actions.MainFormActions.OnExitToolStripMenuItemClick;
            form.SettingsToolStripMenuItem.Click -= actions.MainFormActions.OnSettingsToolStripMenuItemClick;
        }
        #endregion
    }
}
