using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.UPnPBridge.Controllers;
using Zensys.ZWave.UPnPBridge.Actions;

namespace Zensys.ZWave.UPnPBridge.Classes
{
    public class ActionCollection : BaseAction
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="ActionCollection"/> class.
        /// </summary>
        /// <param name="controller">The controller.</param>
        public ActionCollection(ControllerManager controller)
            : base(controller)
        {
        }

        private ControllerFormActions mControllerFormActions;
        private LogFormActions mLogFormActions;
        private MainFormActions mMainFormActions;
        private NodeFormActions mNodeFormActions;
        private UPnPBinaryLightCPActions mUPnPBinaryLightCPActions;
        private BridgedUPnPDevicesActions mBridgedUPnPDevicesActions;
        private UPnPDeviceScannerActions mUPnPDeviceScannerActions;
        private UPnPRendererCPActions mUPnPRendererCPActions;
        private AssociationsFormActions mAssociationsFormActions;
        private CommandClassFormActions mCommandClassFormActions;

        /// <summary>
        /// Gets the controller form actions.
        /// </summary>
        /// <value>The controller form actions.</value>
        public ControllerFormActions ControllerFormActions
        {
            get
            {
                if (mControllerFormActions == null) mControllerFormActions = new ControllerFormActions(this.ControllerManager);
                return mControllerFormActions;
            }

        }
        /// <summary>
        /// Gets the command class form actions.
        /// </summary>
        /// <value>The command class form actions.</value>
        public CommandClassFormActions CommandClassFormActions
        {
            get
            {
                if (mCommandClassFormActions == null) mCommandClassFormActions = new CommandClassFormActions(this.ControllerManager);
                return mCommandClassFormActions;
            }
        }
        /// <summary>
        /// Gets the log form actions.
        /// </summary>
        /// <value>The log form actions.</value>
        public LogFormActions LogFormActions
        {
            get
            {
                if (mLogFormActions == null) mLogFormActions = new LogFormActions(this.ControllerManager);
                return mLogFormActions;
            }
        }
        /// <summary>
        /// Gets the main form actions.
        /// </summary>
        /// <value>The main form actions.</value>
        public MainFormActions MainFormActions
        {
            get
            {
                if (mMainFormActions == null) mMainFormActions = new MainFormActions(this.ControllerManager);
                return mMainFormActions;
            }
        }
        /// <summary>
        /// Gets the node form actions.
        /// </summary>
        /// <value>The node form actions.</value>
        public NodeFormActions NodeFormActions
        {
            get
            {
                if (mNodeFormActions == null) mNodeFormActions = new NodeFormActions(this.ControllerManager);
                return mNodeFormActions;
            }
        }

        public UPnPBinaryLightCPActions UPnPBinaryLightCPActions
        {
            get
            {
                if (mUPnPBinaryLightCPActions == null) mUPnPBinaryLightCPActions = new UPnPBinaryLightCPActions(this.ControllerManager);
                return mUPnPBinaryLightCPActions;
            }
        }

        public BridgedUPnPDevicesActions BridgedUPnPDevicesActions
        {
            get
            {
                if (mBridgedUPnPDevicesActions == null) mBridgedUPnPDevicesActions = new BridgedUPnPDevicesActions(this.ControllerManager);
                return mBridgedUPnPDevicesActions;
            }
        }
        public UPnPDeviceScannerActions UPnPDeviceScannerActions
        {
            get
            {
                if (mUPnPDeviceScannerActions == null) mUPnPDeviceScannerActions = new UPnPDeviceScannerActions(this.ControllerManager);
                return mUPnPDeviceScannerActions;
            }
        }
        public UPnPRendererCPActions UPnPRendererCPActions
        {
            get
            {
                if (mUPnPRendererCPActions == null) mUPnPRendererCPActions = new UPnPRendererCPActions(this.ControllerManager);
                return mUPnPRendererCPActions;
            }
        }
        public AssociationsFormActions AssociationsFormActions
        {
            get
            {
                if (mAssociationsFormActions == null) mAssociationsFormActions = new AssociationsFormActions(this.ControllerManager);
                return mAssociationsFormActions;
            }
        }
    }
}
