using System;
using System.Collections.Generic;
using System.Text;
using Zensys.ZWave.Application;
using System.Threading;

namespace Zensys.PCController
{
    public class ProcessACH
    {
        private static object locker = new object();
        private static Queue<DataFrame> FramesQueueTemp;
        private static Queue<DataFrame> FramesQueueProcessing = new Queue<DataFrame>();
        private static Queue<DataFrame> FramesQueueAdding = new Queue<DataFrame>();
        private static ManualResetEvent QueueNewAddedResetEvent = new ManualResetEvent(false);
        private static ManualResetEvent QueueLockedResetEvent = new ManualResetEvent(false);
        public static void Action(DataFrameDelegate frameReceivedCallback)
        {
            while (true)
            {
                QueueNewAddedResetEvent.WaitOne();
                QueueNewAddedResetEvent.Reset();
                QueueLockedResetEvent.WaitOne();
                lock (locker)
                {
                    FramesQueueTemp = FramesQueueProcessing;
                    FramesQueueProcessing = FramesQueueAdding;
                    FramesQueueAdding = FramesQueueTemp;
                }
                if (frameReceivedCallback != null)
                {
                    while (FramesQueueProcessing.Count>0)
                    {
                        DataFrame dItem = FramesQueueProcessing.Dequeue();
                        frameReceivedCallback(dItem.Source, dItem.IsBroadcast, dItem.Values);
                    }
                }

                // tweak CPU usage changing this value. 0ms - Max update frequency and CPU usage. 
                // Recomended value: 10-100ms.
                // queue filled during this time with Add method
                Thread.Sleep(5);
            }
        }
        public static void Add(byte source, bool isBroadcast, CommandClassValue[] values)
        {
            DataFrame dItem = new DataFrame(source, isBroadcast, values);
            lock (locker)
            {
                FramesQueueAdding.Enqueue(dItem);
            }
            QueueNewAddedResetEvent.Set();
        }

        public static void Pause()
        {
            QueueLockedResetEvent.Reset();
            lock (locker)
            {
                FramesQueueAdding.Clear();
            }
        }

        public static void Resume()
        {
            QueueLockedResetEvent.Set();
        }
        public delegate void DataFrameDelegate(byte source, bool isBroadcast, CommandClassValue[] values);
        public class DataFrame
        {
            public DataFrame(byte source, bool isBroadcast, CommandClassValue[] values)
            {
                Source = source;
                IsBroadcast = isBroadcast;
                Values = values;
            }
            public byte Source;
            public bool IsBroadcast;
            public CommandClassValue[] Values;
        }
    }
}
