using System;
using System.Collections.Generic;
using System.Text;
using Zensys.PCController.Classes;
using Zensys.PCController.Models;

namespace Zensys.PCController.Interfaces
{
    /// <summary>
    /// Defines methods for binding views (windows forms) and controller extentions <see cref="BaseAction"/>
    /// </summary>
    public interface IViewDispatcher
    {
        /// <summary>
        /// Binds the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions.</param>
        void Bind(IView view, ActionCollection actions, DocumentModel documentModel);
        /// <summary>
        /// Drops the specified view.
        /// </summary>
        /// <param name="view">The view.</param>
        /// <param name="actions">The actions.</param>
        void Drop(IView view, ActionCollection actions, DocumentModel documentModel);
    }
}
